/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.definition;

import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.Example;
import at.mrdevelopment.toolkit.definition.TemplateAttributes;
import at.mrdevelopment.toolkit.options.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public enum TemplateNode {
    ROOT_IMAGE("image", Arrays.asList(TemplateAttributes.ROOT_IMAGE_ATTRIBUTES), false, "The root element of the image template. It specifies the basic attributes (e.g. size, background) of the image to be generated as well as default values for font and color.", null),
    FIELD("field", Arrays.asList(TemplateAttributes.FIELD_ATTRIBUTES), true, "The field element defines a rectangular container in which an image, text or a barcode can be placed.\nThe position of the field can either be set by specifiying the x and y coordinates of the top left corner or by just setting the x coordinate. In the second case, the field is positioned exactly after the last field, which specified the y-coordinate (or 0, in case no field has a y-coordinate specified).", new Example[]{Example.EXAMPLE_NESTED_FIELDS}),
    TABLE("table", Arrays.asList(TemplateAttributes.TABLE_ATTRIBUTES), true, "The table element indicates the beginning of a table followed by table rows and cells. By default the table takes the width from the field it is placed in. The height of the table depends on the height of the rows inside of them.", new Example[]{Example.TABLE_1}),
    TABLE_ROW("row", Arrays.asList(TemplateAttributes.TABLE_ROW_ATTRIBUTES), true, "The row element indicates a new row inside a table. Its height and width can be specified, if they are not specified, the row uses the maximum width and as much height as its content uses.", new Example[]{Example.TABLE_1}),
    TABLE_DATA("cell", Arrays.asList(TemplateAttributes.TABLE_DATA_ATTRIBUTES), true, "The cell element stands for a table cell inside a table row. It is possible to set a fixed width. When a fixed width is set, the column size of the whole table will be set to this value, or to the maximum if multiple cells specifiy a width in this column. If not set, the width of the cell will be equally distributed.", new Example[]{Example.TABLE_1}),
    IMAGE("img", Arrays.asList(TemplateAttributes.IMAGE_ATTRIBUTES), true, "In order to insert an image in front of the background use this tag. It is supposed to take either a relative path from the template to an image file or a Base64 encoded string of an image.\nBe careful when using a path to an image, when processing the template on the server, the path may be different or the image may not exist at all on the server.", new Example[]{Example.IMAGE_1}),
    BARCODE("barcode", Arrays.asList(TemplateAttributes.BARCODE_FIELD_ATTRIBUTES), true, "The barcode element defines the properties in order to output a barcode on the image.", new Example[]{Example.BARCODE_1}),
    RECT("rect", Arrays.asList(TemplateAttributes.RECT_ATTRIBUTES), true, "Defines a rectangle to be drawn onto the image. The rectangle will be drawn behind the field elements.", new Example[]{Example.DRAWING_1, Example.DRAWING_2}),
    LINE("line", Arrays.asList(TemplateAttributes.LINE_ATTRIBUTES), true, "Defines the properties of a line, which will be drawn onto the image. The line will be drawn behind the field elements.", new Example[]{Example.DRAWING_1, Example.DRAWING_2}),
    TRIANGLE("triangle", Arrays.asList(TemplateAttributes.TRIANGLE_ATTRIBUTES), true, "Defines a triangle to be drawn onto the image. The triangle will be drawn behind the field elements.", new Example[]{Example.DRAWING_1, Example.DRAWING_2}),
    ELLIPSE("ellipse", Arrays.asList(TemplateAttributes.ELLIPSE_ATTRIBUTES), true, "Defines an ellipse to be drawn onto the image. The ellipse will be drawn behind the field elements.", new Example[]{Example.DRAWING_1, Example.DRAWING_2}),
    POLYGON("polygon", Arrays.asList(TemplateAttributes.POLYGON_ATTRIBUTES), true, "Defines a polygon to be drawn onto the image. The polygon will be drawn behind the field elements.", new Example[]{Example.DRAWING_1, Example.DRAWING_2}),
    TEXT("text", Arrays.asList(TemplateAttributes.TEXT_ATTRIBUTES), true, "The text element specifies the properties for the containing text. The field element can contain multiple text elements.\nThe text element's font properties are inheritated from the root image tag.\nIn order to automatically fit multiple text elements into a field, leave out the y position attribute. The text then gets positioned one underneath the other (Note: be cautious with the auto-spacing attribute. In case of dynamic positioning the first text element uses the whole space of the field then.).", new Example[]{Example.MULTI_LINE}),
    LABEL("label", Arrays.asList(TemplateAttributes.LABEL_ATTRIBUTES), true, "This element defines a single lined text. The contained text is cut off if it is too long and not wrapped.", new Example[]{Example.MULTI_LINE}),
    SPAN("span", Arrays.asList(TemplateAttributes.SPAN_ATTRIBUTES), true, "The span element is specified inside the text element in order to format the contained text differently (no automatic line break after span element).", new Example[]{Example.SPAN_1}),
    UL("ul", Arrays.asList(TemplateAttributes.UNORDERED_LIST_ATTRIBUTES), true, "The ul element defines a unordered list similar to the HTML <ul> tag. The elements defined by li elements are then formatted as unordered list.", new Example[]{Example.LIST_1}),
    OL("ol", Arrays.asList(TemplateAttributes.ORDERED_LIST_ATTRIBUTES), true, "The ol element defines a unordered list similar to the HTML <ol> tag. The elements defined by li elements are then formatted as ordered list.", new Example[]{Example.LIST_1}),
    LI("li", Arrays.asList(TemplateAttributes.LIST_ELEMENT_ATTRIBUTES), true, "The li element defines a single list element, similar to the HTML <li> tag.", new Example[]{Example.LIST_1}),
    BR("br", new ArrayList<Attribute>(), true, "The br element is specified inside the text element and forces a line break. It takes no attributes.", null),
    PLAIN_TEXT("#text", new ArrayList<Attribute>(), true, "Plain text, which will be used to generate a barcode or will be displayed in the generated image.", null),
    BARCODE_CODABAR("codabar", Arrays.asList(TemplateAttributes.BARCODE_CODABAR_ATTRIBUTES), false, "", new Example[]{Example.BARCODE_1}),
    BARCODE_CODE128("code128", Arrays.asList(TemplateAttributes.BARCODE_CODE128_ATTRIBUTES), false, "", new Example[]{Example.BARCODE_1}),
    BARCODE_CODE39("code39", Arrays.asList(TemplateAttributes.BARCODE_CODE39_ATTRIBUTES), false, "", new Example[]{Example.BARCODE_1}),
    BARCODE_DATAMATRIX("datamatrix", Arrays.asList(TemplateAttributes.BARCODE_DATAMATRIX_ATTRIBUTES), false, "", new Example[]{Example.BARCODE_1}),
    BARCODE_EAN128("ean-128", Arrays.asList(TemplateAttributes.BARCODE_EAN128_ATTRIBUTES), false, "", new Example[]{Example.BARCODE_1}),
    BARCODE_EAN13("ean13", Arrays.asList(TemplateAttributes.BARCODE_EAN13_ATTRIBUTES), false, "", new Example[]{Example.BARCODE_1}),
    BARCODE_EAN8("ean8", Arrays.asList(TemplateAttributes.BARCODE_EAN8_ATTRIBUTES), false, "", new Example[]{Example.BARCODE_1}),
    BARCODE_INTL2OF5("intl2of5", Arrays.asList(TemplateAttributes.BARCODE_INTL2OF5_ATTRIBUTES), false, "", new Example[]{Example.BARCODE_1}),
    BARCODE_ITF14("itf-14", Arrays.asList(TemplateAttributes.BARCODE_ITF14_ATTRIBUTES), false, "", new Example[]{Example.BARCODE_1}),
    BARCODE_PDF417("pdf417", Arrays.asList(TemplateAttributes.BARCODE_PDF417_ATTRIBUTES), false, "", new Example[]{Example.BARCODE_1}),
    BARCODE_POSTNET("postnet", Arrays.asList(TemplateAttributes.BARCODE_POSTNET_ATTRIBUTES), false, "", new Example[]{Example.BARCODE_1}),
    BARCODE_QR("qr", Arrays.asList(TemplateAttributes.BARCODE_QR_ATTRIBUTES), false, "", new Example[]{Example.BARCODE_1}),
    BARCODE_ROYALMAIL("royal-mail-cbc", Arrays.asList(TemplateAttributes.BARCODE_ROYALMAIL_ATTRIBUTES), false, "", new Example[]{Example.BARCODE_1}),
    BARCODE_UPCA("upc-a", Arrays.asList(TemplateAttributes.BARCODE_UPCA_ATTRIBUTES), false, "", new Example[]{Example.BARCODE_1}),
    BARCODE_UPCE("upc-e", Arrays.asList(TemplateAttributes.BARCODE_UPCE_ATTRIBUTES), false, "", new Example[]{Example.BARCODE_1}),
    BARCODE_USPS4CB("usps4cb", Arrays.asList(TemplateAttributes.BARCODE_USPS4CB_ATTRIBUTES), false, "", new Example[]{Example.BARCODE_1});

    private final List<Attribute> attributeList;
    private final String key;
    private final boolean multipleOccurrences;
    private List<Map<String, Option<?>>> options;
    private final String description;
    private final Example[] examples;

    private TemplateNode(String key, List<Attribute> attributeList, boolean multipleOccurencies, String description, Example[] examples) {
        this.key = key;
        this.attributeList = attributeList;
        this.multipleOccurrences = multipleOccurencies;
        this.description = description;
        this.examples = examples;
        this.options = new ArrayList();
    }

    public List<Attribute> getAttributeList() {
        return this.attributeList;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isMultipleOccurrences() {
        return this.multipleOccurrences;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Map<String, Option<?>>> getOptions() {
        return this.options;
    }

    public void addOptions(Map<String, Option<?>> newOptions) {
        this.options.add(newOptions);
    }

    public Example[] getExamples() {
        return this.examples;
    }
}

