/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.definition;

import at.mrdevelopment.toolkit.definition.TemplateNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TemplateDefinitionTree {
    private static TemplateDefinitionTree tree;
    private static Map<String, TemplateNode> barcodeTypes;
    private static final String BARCODE_TEMPLATE_NODE_PREFIX = "BARCODE_";
    private final TemplateDefinitionNode rootNode = new TemplateDefinitionNode(TemplateNode.ROOT_IMAGE, null);

    public static TemplateDefinitionTree getTree() {
        if (tree == null) {
            tree = new TemplateDefinitionTree();
        }
        return tree;
    }

    public static Map<String, TemplateNode> getBarcodeTypes() {
        if (barcodeTypes == null) {
            TemplateDefinitionTree.initBarcodeTypes();
        }
        return barcodeTypes;
    }

    private static void initBarcodeTypes() {
        barcodeTypes = new HashMap<String, TemplateNode>();
        for (TemplateNode templateNode : TemplateNode.values()) {
            if (!templateNode.name().startsWith(BARCODE_TEMPLATE_NODE_PREFIX)) continue;
            barcodeTypes.put(templateNode.getKey(), templateNode);
        }
    }

    private TemplateDefinitionTree() {
        TemplateDefinitionNode fieldNode = new TemplateDefinitionNode(TemplateNode.FIELD, this.rootNode);
        fieldNode.addChild(fieldNode);
        TemplateDefinitionNode tableNode = new TemplateDefinitionNode(TemplateNode.TABLE, fieldNode);
        TemplateDefinitionNode tableRowNode = new TemplateDefinitionNode(TemplateNode.TABLE_ROW, tableNode);
        TemplateDefinitionNode tableDataNode = new TemplateDefinitionNode(TemplateNode.TABLE_DATA, tableRowNode);
        this.createLabelNode(tableDataNode);
        this.createTextNode(tableDataNode);
        TemplateDefinitionNode barcodeNode = new TemplateDefinitionNode(TemplateNode.BARCODE, fieldNode);
        new TemplateDefinitionNode(TemplateNode.PLAIN_TEXT, barcodeNode);
        new TemplateDefinitionNode(TemplateNode.IMAGE, fieldNode);
        this.createLabelNode(fieldNode);
        this.createTextNode(fieldNode);
        new TemplateDefinitionNode(TemplateNode.RECT, this.rootNode);
        new TemplateDefinitionNode(TemplateNode.LINE, this.rootNode);
        new TemplateDefinitionNode(TemplateNode.TRIANGLE, this.rootNode);
        new TemplateDefinitionNode(TemplateNode.ELLIPSE, this.rootNode);
        new TemplateDefinitionNode(TemplateNode.POLYGON, this.rootNode);
        new TemplateDefinitionNode(TemplateNode.RECT, fieldNode);
        new TemplateDefinitionNode(TemplateNode.LINE, fieldNode);
        new TemplateDefinitionNode(TemplateNode.TRIANGLE, fieldNode);
        new TemplateDefinitionNode(TemplateNode.ELLIPSE, fieldNode);
        new TemplateDefinitionNode(TemplateNode.POLYGON, fieldNode);
    }

    public List<TemplateNode> getChildNode(TemplateNode templateNode) {
        ArrayList<TemplateNode> templateNodes = new ArrayList<TemplateNode>();
        TemplateDefinitionNode node = this.getNode(this.rootNode, templateNode);
        if (node != null) {
            for (TemplateDefinitionNode child : node.getChilds()) {
                templateNodes.add(child.getTemplateNode());
            }
        }
        return templateNodes;
    }

    private TemplateDefinitionNode getNode(TemplateDefinitionNode node, TemplateNode templateNode) {
        if (node.getTemplateNode().equals((Object)templateNode)) {
            return node;
        }
        for (TemplateDefinitionNode child : node.getChilds()) {
            TemplateDefinitionNode foundNode = this.getNode(child, templateNode);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    private TemplateDefinitionNode createLabelNode(TemplateDefinitionNode parentNode) {
        TemplateDefinitionNode labelNode = new TemplateDefinitionNode(TemplateNode.LABEL, parentNode);
        new TemplateDefinitionNode(TemplateNode.PLAIN_TEXT, labelNode);
        TemplateDefinitionNode labelSpanNode = new TemplateDefinitionNode(TemplateNode.SPAN, labelNode);
        new TemplateDefinitionNode(TemplateNode.PLAIN_TEXT, labelSpanNode);
        return labelNode;
    }

    private TemplateDefinitionNode createTextNode(TemplateDefinitionNode parentNode) {
        TemplateDefinitionNode textNode = new TemplateDefinitionNode(TemplateNode.TEXT, parentNode);
        new TemplateDefinitionNode(TemplateNode.PLAIN_TEXT, textNode);
        new TemplateDefinitionNode(TemplateNode.BR, textNode);
        TemplateDefinitionNode textSpanNode = new TemplateDefinitionNode(TemplateNode.SPAN, textNode);
        new TemplateDefinitionNode(TemplateNode.PLAIN_TEXT, textSpanNode);
        TemplateDefinitionNode ulTemplateDefinitionNode = new TemplateDefinitionNode(TemplateNode.UL, textNode);
        TemplateDefinitionNode ulLiNode = new TemplateDefinitionNode(TemplateNode.LI, ulTemplateDefinitionNode);
        new TemplateDefinitionNode(TemplateNode.PLAIN_TEXT, ulLiNode);
        new TemplateDefinitionNode(TemplateNode.BR, ulLiNode);
        TemplateDefinitionNode ulSpanNode = new TemplateDefinitionNode(TemplateNode.SPAN, ulLiNode);
        new TemplateDefinitionNode(TemplateNode.PLAIN_TEXT, ulSpanNode);
        TemplateDefinitionNode olTemplateDefinitionNode = new TemplateDefinitionNode(TemplateNode.OL, textNode);
        TemplateDefinitionNode olLiNode = new TemplateDefinitionNode(TemplateNode.LI, olTemplateDefinitionNode);
        new TemplateDefinitionNode(TemplateNode.PLAIN_TEXT, olLiNode);
        new TemplateDefinitionNode(TemplateNode.BR, olLiNode);
        TemplateDefinitionNode olSpanNode = new TemplateDefinitionNode(TemplateNode.SPAN, olLiNode);
        new TemplateDefinitionNode(TemplateNode.PLAIN_TEXT, olSpanNode);
        return textNode;
    }

    public TemplateDefinitionNode getRoot() {
        return this.rootNode;
    }

    public class TemplateDefinitionNode {
        private final TemplateNode templateNode;
        private TemplateDefinitionNode parent;
        private List<TemplateDefinitionNode> childs = new ArrayList<TemplateDefinitionNode>();

        public TemplateDefinitionNode(TemplateNode templateNode, TemplateDefinitionNode parent) {
            this.templateNode = templateNode;
            this.parent = parent;
            if (parent != null) {
                this.parent.addChild(this);
            }
        }

        public TemplateDefinitionNode getParent() {
            return this.parent;
        }

        public List<TemplateDefinitionNode> getChilds() {
            return this.childs;
        }

        private void addChild(TemplateDefinitionNode node) {
            this.childs.add(node);
        }

        public TemplateNode getTemplateNode() {
            return this.templateNode;
        }
    }
}

