/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.definition;

import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.options.MissingRequiredOptionException;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class Element {
    private Map<String, Option<?>> options;

    public Element(Map<String, Option<?>> options, boolean ignoreAttributes) throws OptionException {
        this(options, null, ignoreAttributes);
    }

    public Element(Map<String, Option<?>> options) throws OptionException {
        this(options, null, false);
    }

    public Element(Map<String, Option<?>> options, Class<? extends Element> elementClass) throws OptionException {
        this(options, elementClass, false);
    }

    public Element(Map<String, Option<?>> options, Class<? extends Element> elementClass, boolean ignoreAttributes) throws OptionException {
        if (!ignoreAttributes) {
            List<Attribute> attributes = elementClass != null ? this.getAttributes(elementClass) : this.getAttributes();
            Collection<Attribute> requiredAttributes = this.getRequiredAttributes();
            for (Attribute attribute : attributes) {
                if (!options.containsKey(attribute.getKey())) {
                    throw new OptionException(String.format("Missing option: %s", attribute.getKey()));
                }
                if (!requiredAttributes.contains((Object)attribute) || options.get(attribute.getKey()).get() != null) continue;
                throw new MissingRequiredOptionException(String.format("Missing required attribute %s", attribute.getKey()), attribute);
            }
        }
        this.options = options;
    }

    protected Map<String, Option<?>> getOptions() {
        return this.options;
    }

    public List<Attribute> getAttributes() {
        return this.getAttributes(this.getClass());
    }

    public List<Attribute> getAttributes(Class<? extends Element> elementClass) {
        return elementClass.getAnnotation(TemplateElementType.class).type().getAttributeList();
    }

    public abstract Collection<Attribute> getRequiredAttributes();
}

