/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.definition;

import at.mrdevelopment.toolkit.barcode.Barcode1D;
import at.mrdevelopment.toolkit.barcode.specific.QRCode;
import at.mrdevelopment.toolkit.definition.AttributeDescriptions;
import at.mrdevelopment.toolkit.definition.AutoScale;
import at.mrdevelopment.toolkit.image.BorderStyle;
import at.mrdevelopment.toolkit.image.DitheringThreshold;
import at.mrdevelopment.toolkit.image.RoundedCorner;
import at.mrdevelopment.toolkit.image.VerticalAlignment;
import at.mrdevelopment.toolkit.text.Alignment;
import at.mrdevelopment.toolkit.text.LineWrap;
import at.mrdevelopment.toolkit.text.SuperScript;
import at.mrdevelopment.toolkit.text.TextElement;

public enum AttributeDescription {
    COLOR("The color of the element or the contained text", "black | white | transparent | semi-colon separated RGBA string with values between 0 and 255"),
    BACKGROUND_COLOR("The background color of the element", "black | white | transparent | semi-colon separated RGBA string with values between 0 and 255"),
    WIDTH("The width of the element specified in pixels", "A size value in pixel"),
    HEIGHT("The height of the element specified in pixels", "A size value in pixel"),
    X("The position of the element on the x-axis in pixels", "An integer value >= 0 and smaller than the specified image dimension"),
    Y("The position of the element on the y-axis in pixels", "An integer value >= 0 and smaller than the specified image dimension"),
    FONT_FAMILY("The name of the font to be used", "A font name (e.g. Arial, Tahoma, Times New Roman, etc.) or mutliple font names separated by a colon. The system will use the first font which is available."),
    FONT_STYLE("Specifies whether the text should be printed normal or italic", TextElement.FontStyle.values()),
    FONT_WEIGHT("Specifies whether the text should be printed normal or bold", TextElement.FontWeight.values()),
    TEXT_DECORATION("Specifies a decoration for the given text (underline, overline, linethrough or none)", TextElement.TextDecoration.values()),
    FONT_SIZE("Specifies a set of font sizes separated by colon. The text will be rendered with the biggest possible (and specified) font size", "A positive integer describing the font size in pt or multiple integers separated by a colon as alternative font seizes"),
    PADDING_TOP("Specifies the padding in pixels from the top", "A positive or negative integer value"),
    PADDING_RIGHT("Specifies the padding in pixels from the right", "A positive or negative integer value"),
    PADDING_BOTTOM("Specifies the padding in pixels from the bottom", "A positive or negative integer value"),
    PADDING_LEFT("Specifies the padding in pixels from the left", "A positive or negative integer value"),
    MAX_SPACING("Specifies the maximum number of pixels used for line spacing", "An non-negative integer value (>0)"),
    MIN_SPACING("Specifies the minimum number of pixels used for line spacing", "An non-negative integer value (>0)"),
    AUTO_SPACING("Specifies whether the spacing of the text should be set automatically to fill the available space", "true|false"),
    SPACING("Manually specify the spacing in pixels", "An non-negative integer value (>0)"),
    ALIGNMENT("Specifies the horizontal alignment of the element/text", Alignment.values()),
    VERTICAL_ALIGNMENT("Specifies the vertical alignment of the element/text", VerticalAlignment.values()),
    BACKGROUND_IMAGE("Defines a background image for the element. The path to the image should be given relative to the used template. If the image is too small the image gets clipped to the upper left corner", "A path relative to the template file or a URL. (e.g. \"../test/image.png or http://url.to/image.png\")"),
    ROTATION("Defines the rotation of the image to output. The rotation is only available for 0, 90, 180 and 270 degrees", "0|90|180|270"),
    BORDER("Specifies the thickness of the border around the element. A value of 0 means no border", "An non-negative integer value (>0)"),
    BORDER_COLOR("Specifies the color of the used border", "black | white | transparent | semi-colon separated RGBA string with values between 0 and 255"),
    FILL("Specifies whether the element should be filled with the specified color or net", "true|false"),
    X_FROM("Specifies the start location on the x-axis in pixels", "An integer value >= 0 and smaller than the specified image dimension"),
    Y_FROM("Specifies the start location on the y-axis in pixels", "An integer value >= 0 and smaller than the specified image dimension"),
    X_TO("Specifies the end location on the x-axis in pixels", "An integer value >= 0 and smaller than the specified image dimension"),
    Y_TO("Specifies the end location on the y-axis in pixels", "An integer value >= 0 and smaller than the specified image dimension"),
    THICKNESS("Specifies the line thickness in pixels", "A positive integer value (>=0)"),
    BULLET_TYPE("Specifies which type of bullet should be used for the enumeration", AttributeDescriptions.createBulletTypeValuesString()),
    SOURCE("Defines the path or a URL to an image. The path has to be relative to the template file", "A path relative to the template file or a URL. (e.g. \"../test/image.png or http://url.to/image.png\")"),
    DATA("Specifies a Base64 encoded string as image source", "A Base64 encoded string"),
    BARCODE_TYPE("The type of barcode that should be created", "codabar | code128 | code39 | ean13 | ean8 | ean-128 | upc-a | upc-e | intl2of5 | itf-14 | postnet | royal-mail-cbc | usps4cb | pdf417 | datamatrix | qr"),
    FONT_SIZE_PT("Font size of the text below the barcode showing the human readable content", "A positive integer value (>=0)"),
    FONT_NAME("Defines the font of the text content of the barcode", "A font name (e.g. Arial, Tahoma, Times New Roman, etc.) or mutliple font names separated by a colon. The system will use the first font which is available."),
    QUIET_ZONE_FACTOR("Factor for calculating the barcode's quiet zone", "An non-negative integer value (>0)"),
    VERTICAL_QUIET_ZONE_FACTOR("Factor for calculating vertical quiet zone", "An non-negative integer value (>0)"),
    QUIET_ZONE_ENABLED("Whether quiet zone should be en/disabled", "true|false"),
    HUMAN_READABLE_ENABLED("Enables or disables displaying the text content of the barcode", "true|false"),
    HUMAN_READABLE_PLACEMENT("Defines where the text content should be displayed, relative to the barcode", Barcode1D.HumanReadablePlacement.values()),
    SCALE("Sets the scale for the barcode itself", "A positive integer value (>=0)"),
    AUTO_SCALE("Enables/disables to automatically scale the element. The element will scaled to the size of the field", "true|false"),
    AUTO_SCALE_IMAGE("Specifies whether an image is scaled up or down according to the size of the field. ", AutoScale.values()),
    PADDED("Enables/disables padding", "true|false"),
    CHECKSUM_MODE("Configures the handling of the checksum", Barcode1D.ChecksumMode.values()),
    ERROR_CORRECTION_LEVEL("Specifies the error correction level of the QR tag", QRCode.ErrorCorrectionLevel.values()),
    ROW_HEIGHT_RATIO("Specifies the row height ratio for the pdf417 barcode", "A positive float number (>0)"),
    COLUMNS("Specifies the number of columns. Can be disabled using a zero value, in this case it is automatically detected", "An non-negative integer value (>0)"),
    MIN_COLUMNS("Specifies the minimum number of columns", "An non-negative integer value (>0)"),
    MAX_COLUMNS("Specifies the maximum number of columns", "An non-negative integer value (>0)"),
    MIN_ROWS("Specifies the minimum number of rows", "An non-negative integer value (>0)"),
    MAX_ROWS("Specifies the maximum number of rows", "An non-negative integer value (>0)"),
    EC_LEVEL("Sets the EC level for pdf417 barcodes", "An integer number between 0 and 8"),
    WIDTH_TO_HEIGHT_RATIO("Specifies the ratio between width and height", "A positive float number (>0)"),
    BEARER_BAR_WIDTH("Specifies the bearer box width (border) for itf-14 barcodes in pixels", "A positive integer value (>=0)"),
    BEARER_BOX("Enables/disables the bearer box", "true|false"),
    WIDE_FACTOR("Specifies the factor that is used to calculate the space between the barcode stripes", "A positive float number (>0)"),
    DISPLAY_CHECKSUM("Shows/hides the checksum", "true|false"),
    TEMPLATE("Sets an optional template for the ean-128 barcode", "String"),
    OMIT_BRACKETS("Enables/Disables bracket omitting for ean-128 barcode", "true|false"),
    DISPLAY_START_STOP("Enables/Disables display start and stop feature for codabar and code-39 barcodes", "true|false"),
    INTERCHAR_GAP_WIDTH("Sets the gap width of the code-39 barcode", "An non-negative integer value (>0)"),
    EXTENDED_CHARSET("Enables/disables extended charset for code-39 barcodes", "true|false"),
    CODESETS("Sets the code set for code-128 barcodes", "A string combination of A, B and C"),
    AUTO_MODE("Enables/disables auto mode of pdf-417 barcodes", "true|false"),
    SHAPE("Sets the shape of the data matrix", "none|rectangle|shape"),
    MIN_SYMBOL_SIZE_WIDTH("Sets the minimum symbol width", "A positive integer value (>=0)"),
    MIN_SYMBOL_SIZE_HEIGHT("Sets the minimum symbol height", "A positive integer value (>=0)"),
    MAX_SYMBOL_SIZE_WIDTH("Sets the maximum symbol width", "A positive integer value (>=0)"),
    MAX_SYMBOL_SIZE_HEIGHT("Sets the maximum symbol height", "A positive integer value (>=0)"),
    CLINCH("Automatically clinches the text to fit into the field, if set true", "true|false"),
    CONDENSE("Automatically condenses text if it is too long using the best matching condense factor specified", "One or more float numbers separated by a colon."),
    LINE_SPACING("Sets the spacing between text lines in pixel (negative values decrease the line spacing)", "A positive or negative integer value"),
    FLOAT("Used to create a floating list. A floating list is wrapped the same way as normal text, there is no line break after each element. The list, however, is not wrapped after the bullet and before the first character", "true|false"),
    WRAPPED_LINE_SPACING("Sets the line spacing for auto wrapped lines inside a list (negative values decrease the line spacing)", "A positive or negative integer value"),
    MAX_HEIGHT("Defines the maximum height of a field. This attribute is used in combination with a relative y-positioning. The height of the rendered field will be smaller or equal the specified maximum height value, depending on its content", "An non-negative integer value (>0)"),
    ID("A identifier of the tag. This identifier can be referenced via a CSS file. This identifier has to be unique", "String"),
    CLASS("A identifier of a CSS class. This identifier can be referenced via a CSS file. The same class identifier is meant to be used in multiple tags", "String"),
    CELLPADDING("Defines the spacing around the text content of a table cell in pixel", "A positive integer value (>=0)"),
    TABLE_WIDTH("Defines the width of the current table element", "A positive integer value (>=0)"),
    TABLE_HEIGHT("Defines the height of the current table element", "A positive integer value (>=0)"),
    TABLE_BORDER("Sets the border width of the whole table except the header row and/or column. The width of the header row/column is set through the attribute 'header-border'. A border of zero means no border", "An non-negative integer value (>0)"),
    HEADER_BORDER("Sets the border width of header row and column. This attribute only takes effect if 'header-row' and or 'header-column' is enabled", "An non-negative integer value (>0)"),
    HEADER_ROW("The header row is the first row of a table. The border width of this row can be set with 'header-border', if enabled", "true|false"),
    HEADER_COLUMN("The header column is the first column of a table. The border width of this column can be set with 'header-border', if enabled", "true|false"),
    INVERT("Inverts the colors of the image", "true|false"),
    EQUALIZE("Performs a histogram equalization on the image", "true|false"),
    TRIANGLE_COORDINATE("Coordinate defining an edge of a triangle", "An integer value >= 0 and smaller than the specified image dimension"),
    ROTATION_ANGLE("A positive or negative rotation angle to rotate the corresponding field content", "An integer value >= 0 and smaller than the specified image dimension"),
    POLYGON_COORDINATES("A whitespace separated list of coordinates used to draw a polygon", "A whitespace separated list of coordinates. Coordinates are separated by colon. e.g. 10,12 221,152"),
    CLIP_X("The x-coordinate of the clipping area", "An integer value >= 0 and smaller than the specified image dimension"),
    CLIP_Y("The y-coordinate of the clipping area", "An integer value >= 0 and smaller than the specified image dimension"),
    CLIP_WIDTH("The width of the clipping area", "A size value in pixel"),
    CLIP_HEIGHT("The height of the clipping area", "A size value in pixel"),
    CORNER_RADIUS("The radius of the rounded corners of the rectangle/field. Zero radius means no rounded corners. In case the corner radius is to large, it gets adjusted automatically. The maximum radius is (Min(width,height) - 1) / 2", "A size value in pixel"),
    ROUNDED_CORNERS("Defines which of the corners should be rounded. Multiple corners can be specified using a colon (,) as separator.", RoundedCorner.values()),
    WRAP("Changes the line wrap of a text field. Normal: line wraps at spaces and dashes. None: no wrapped lines.", LineWrap.values()),
    BULLET_IMAGE("Path containing an image that will be used as bullet.", "A path relative to the template file or a URL. (e.g. \"../test/image.png or http://url.to/image.png\")"),
    BULLET_FONT_FAMILY("Specifies the font of the bullet", "A font name (e.g. Arial, Tahoma, Times New Roman, etc.) or mutliple font names separated by a colon. The system will use the first font which is available."),
    LETTER_SPACING("The letter-spacing attribute increases or decreases the space between characters in a text.", "A possitive or negative float number"),
    BORDER_STYLE("Sets the line style of the border", BorderStyle.values()),
    SUPERSCRIPT("Used to superscript or subscript a text", SuperScript.values()),
    CUT_LEFT("Specifies the number of pixels on each side of the source image which should be cut off.", "A positive integer value (>=0)"),
    CUT_RIGHT("Specifies the number of pixels on each side of the source image which should be cut off.", "A positive integer value (>=0)"),
    CUT_TOP("Specifies the number of pixels on each side of the source image which should be cut off.", "A positive integer value (>=0)"),
    CUT_BOTTOM("Specifies the number of pixels on each side of the source image which should be cut off.", "A positive integer value (>=0)"),
    OUTLINE("Specifies whether the text should be outlined or not", "true|false"),
    OUTLINE_THICKNESS("Specifies the thickness of the text's outline", "An non-negative integer value (>0)"),
    OUTLINE_COLOR("Specifies the color of the text's outline", "black | white | transparent | semi-colon separated RGBA string with values between 0 and 255"),
    OUTLINE_INSIDE("This value determines, whether the outline should be drawn to the inside or outside of the corresponding text", "true|false"),
    SHADOW("Enables or disables the shadow", "true|false"),
    SHADOW_COLOR("Sets the color of the shadow", "black | white | transparent | semi-colon separated RGBA string with values between 0 and 255"),
    SHADOW_SIZE("The size of the shadow in pixels", "An non-negative integer value (>0)"),
    SHADOW_ALPHA("The alpha value (transparency) of the shadow", "A positive float number >= 0 and <= 1"),
    SHADOW_BLUR("Whether the shadow should be rendered with or without blur effect", "true|false"),
    DITHERING("Enables or disables dithering for the resulting image", "true|false"),
    SHADOW_ANGLE("Specifies the angle of the shadow", "A possitive or negative float number"),
    THRESHOLD("Specifies the threshold for converting the image to black/white", "A positive integer between 0 and 255"),
    DITHERING_THRESHOLD("Dithers given image with different values, per default the image will be dithered with the origninal floyd-steinberg algorithem and with medium and high the image will be dithered with a modified version of the algorithem", DitheringThreshold.values());

    private final String description;
    private final String possibleValueDescription;

    private AttributeDescription(String description, Enum<?>[] enums, String others) {
        this.description = description;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < enums.length; ++i) {
            Enum<?> enumValue = enums[i];
            builder.append(enumValue.name().toLowerCase());
            if (i >= enums.length - 1) continue;
            builder.append(" | ");
        }
        if (others != null) {
            builder.append(" | ");
            builder.append(others);
        }
        this.possibleValueDescription = builder.toString();
    }

    private AttributeDescription(String description, Enum<?>[] enums) {
        this(description, enums, null);
    }

    private AttributeDescription(String description, String possibleValueDescription) {
        this.description = description;
        this.possibleValueDescription = possibleValueDescription;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPossibleValueDescription() {
        return this.possibleValueDescription;
    }
}

