/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.datetime;

import at.mrdevelopment.toolkit.datetime.ReloadInterval;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class VariableReloadInterval
implements ReloadInterval {
    private static final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"HH:mm");
    private static final Comparator<DateTime> DATETIME_COMPARATOR = new Comparator<DateTime>(){

        @Override
        public int compare(DateTime d1, DateTime d2) {
            return d1.getMillisOfDay() - d2.getMillisOfDay();
        }
    };
    private final List<DateTime> dateTimes;

    public VariableReloadInterval(Collection<DateTime> dateTimes) {
        this.dateTimes = this.prepareDateTimes(dateTimes);
    }

    private List<DateTime> prepareDateTimes(Collection<DateTime> dateTimesToBePrepared) {
        ArrayList<DateTime> list = new ArrayList<DateTime>(dateTimesToBePrepared);
        Collections.sort(list, DATETIME_COMPARATOR);
        return list;
    }

    @Override
    public long getReloadSleepTimeMillis(DateTime dateTime) {
        for (DateTime time : this.dateTimes) {
            if (DATETIME_COMPARATOR.compare(time, dateTime) <= 0) continue;
            return Math.abs(dateTime.getMillisOfDay() - time.getMillisOfDay());
        }
        DateTime startDate = new DateTime(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth(), this.dateTimes.get(0).getHourOfDay(), this.dateTimes.get(0).getMinuteOfHour()).plusDays(1);
        return startDate.getMillis() - dateTime.getMillis();
    }

    public String toString() {
        Collection times = Collections2.transform(this.dateTimes, (Function)new Function<DateTime, String>(){

            public String apply(DateTime dateTime) {
                return formatter.print((ReadableInstant)dateTime);
            }
        });
        return Joiner.on((String)", ").join((Iterable)times);
    }
}

