/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.datetime;

import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class Time {
    private final DateTime time;
    private DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm");
    private DateTimeFormatter timeFormatter = DateTimeFormat.forPattern((String)"HH:mm");

    public Time(DateTime time) {
        this.time = time;
    }

    public DateTime getDateTime(DateTime dateTime) {
        return DateTime.parse((String)String.format("%s-%s-%s %s:%s", dateTime.year().getAsString(), dateTime.monthOfYear().getAsString(), dateTime.dayOfMonth().getAsString(), this.time.hourOfDay().getAsString(), this.time.minuteOfHour().getAsString()), (DateTimeFormatter)this.dateTimeFormatter);
    }

    public DateTime getNextDateTime(DateTime dateTime) {
        DateTime nextDateTime = this.getDateTime(dateTime);
        if (nextDateTime.isBefore((ReadableInstant)DateTime.now())) {
            return nextDateTime.plusDays(1);
        }
        return nextDateTime;
    }

    public String toString() {
        return this.time.toString(this.timeFormatter);
    }

    public DateTime getTime() {
        return this.time;
    }
}

