/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.datetime;

import at.mrdevelopment.toolkit.datetime.FixedReloadInterval;
import at.mrdevelopment.toolkit.datetime.ReloadInterval;
import at.mrdevelopment.toolkit.datetime.VariableReloadInterval;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ReloadIntervalFactory {
    private static final String DELIMITER = ";";
    private final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"HH:mm");
    private final TimeUnit timeUnit;

    public ReloadIntervalFactory() {
        this(TimeUnit.SECONDS);
    }

    public ReloadIntervalFactory(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public ReloadInterval parseReloadInterval(String input) throws IllegalArgumentException {
        if (input == null || input.isEmpty()) {
            throw new IllegalArgumentException("Empty interval specified");
        }
        try {
            int fixedInterval = Integer.parseInt(input);
            if (fixedInterval < 0) {
                throw new IllegalArgumentException("Interval cannot be negative");
            }
            return new FixedReloadInterval(this.timeUnit, fixedInterval);
        }
        catch (NumberFormatException exc) {
            String[] splitted = input.split(DELIMITER);
            if (splitted.length == 0) {
                throw new IllegalArgumentException(String.format("No time interval specified in %s", input));
            }
            HashSet<DateTime> dateTimes = new HashSet<DateTime>();
            for (String time : splitted) {
                dateTimes.add(this.formatter.parseDateTime(time));
            }
            return new VariableReloadInterval(dateTimes);
        }
    }
}

