/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.datetime;

import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.Years;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public final class ReadableTimeFormatter {
    private static PeriodFormatter periodFormatter = new PeriodFormatterBuilder().printZeroRarelyFirst().appendYears().appendSuffix(" year", " years").appendSeparator(", ", " and ").appendMonths().appendSuffix(" month", " months").appendSeparator(", ", " and ").appendDays().appendSuffix(" day", " days").appendSeparator(", ", " and ").appendHours().appendSuffix(" hour", " hours").appendSeparator(", ", " and ").appendMinutes().appendSuffix(" minute", " minutes").appendSeparator(", ", " and ").appendSeconds().appendSuffix(" second", " seconds").toFormatter();

    public static PeriodFormatter getFormatter() {
        return periodFormatter;
    }

    public static String print(ReadablePeriod period) {
        return periodFormatter.print(period);
    }

    public static String printElapsedTime(ReadableInstant since) {
        Period period = new Period(since, (ReadableInstant)DateTime.now(), PeriodType.yearMonthDayTime());
        return periodFormatter.print((ReadablePeriod)period);
    }

    public static String printElapsedTime(long start, long end) {
        Period period = new Period(start, end, PeriodType.yearMonthDayTime());
        return periodFormatter.print((ReadablePeriod)period);
    }

    public static String printElapsedTime(long ellapsedTimeInMillis) {
        Period period = new Period(ellapsedTimeInMillis);
        return periodFormatter.print((ReadablePeriod)period);
    }

    public static String printMostSignificant(Period period) {
        if (period.getYears() != 0) {
            return ReadableTimeFormatter.print((ReadablePeriod)Years.years((int)period.getYears()));
        }
        if (period.getMonths() != 0) {
            return ReadableTimeFormatter.print((ReadablePeriod)Months.months((int)period.getMonths()));
        }
        if (period.getDays() != 0) {
            return ReadableTimeFormatter.print((ReadablePeriod)Days.days((int)period.getDays()));
        }
        if (period.getHours() != 0) {
            return ReadableTimeFormatter.print((ReadablePeriod)Hours.hours((int)period.getHours()));
        }
        if (period.getMinutes() != 0) {
            return ReadableTimeFormatter.print((ReadablePeriod)Minutes.minutes((int)period.getMinutes()));
        }
        return ReadableTimeFormatter.print((ReadablePeriod)period);
    }

    public static String printMostSignificantElapsedTime(ReadableInstant time) {
        Period period = new Period(time, (ReadableInstant)DateTime.now(), PeriodType.yearMonthDayTime());
        return ReadableTimeFormatter.printMostSignificant(period);
    }

    public static void main(String[] args) {
        System.out.println(ReadableTimeFormatter.print((ReadablePeriod)new Period((Object)new Period(1, 2, 3, 4, 5, 6, 7, 8))));
        System.out.println(ReadableTimeFormatter.printElapsedTime((ReadableInstant)new DateTime(2012, 12, 6, 10, 29)));
        System.out.println(ReadableTimeFormatter.printMostSignificantElapsedTime((ReadableInstant)new DateTime(2012, 12, 5, 10, 29)));
    }
}

