/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.crypto;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class PasswordBasedEncryption {
    static ESLLogger logger = ESLLogger.getLogger(PasswordBasedEncryption.class);
    private static final int AES_KEY_SIZE = 128;
    private static final int PASSWORD_ITERATIONS = 65536;
    private static final int SALT_SIZE = 16;
    private static final int FILESTREAM_BUFFER_SIZE = 8192;
    private SecretKeyFactory secretKeyFactory;
    private Cipher cipher;

    public PasswordBasedEncryption() throws InitializationException {
        try {
            this.secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        }
        catch (Exception exception) {
            throw new InitializationException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encrypt(File inputFile, File outputFile, String password) {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(inputFile);
            outputStream = new FileOutputStream(outputFile);
            this.encrypt(inputStream, outputStream, password);
        }
        catch (FileNotFoundException exception) {
            try {
                logger.error("Could not encrypt file (%s): %s", inputFile.getName(), exception.getMessage());
                logger.logExceptionIfDebugEnabled(exception);
            }
            catch (Throwable throwable) {
                StreamUtils.close(outputStream);
                StreamUtils.close(inputStream);
                throw throwable;
            }
            StreamUtils.close(outputStream);
            StreamUtils.close(inputStream);
        }
        StreamUtils.close(outputStream);
        StreamUtils.close(inputStream);
    }

    public void encrypt(InputStream inputStream, OutputStream outputStream, String password) {
        try {
            byte[] salt = new byte[16];
            new SecureRandom().nextBytes(salt);
            PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt, 65536, 128);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.secretKeyFactory.generateSecret(keySpec).getEncoded(), "AES");
            this.cipher.init(1, secretKeySpec);
            byte[] iv = this.cipher.getParameters().getParameterSpec(IvParameterSpec.class).getIV();
            outputStream.write(salt);
            outputStream.write(iv);
            this.doCrypto(inputStream, outputStream);
        }
        catch (Exception exception) {
            logger.error("Could not encrypt file: %s", exception.getMessage());
            logger.logExceptionIfDebugEnabled(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrypt(File inputFile, File outputFile, String password) {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(inputFile);
            outputStream = new FileOutputStream(outputFile);
            this.decrypt(inputStream, outputStream, password);
        }
        catch (FileNotFoundException exception) {
            try {
                logger.error("Could not decrypt file (%s): %s", inputFile.getName(), exception.getMessage());
                logger.logExceptionIfDebugEnabled(exception);
            }
            catch (Throwable throwable) {
                StreamUtils.close(outputStream);
                StreamUtils.close(inputStream);
                throw throwable;
            }
            StreamUtils.close(outputStream);
            StreamUtils.close(inputStream);
        }
        StreamUtils.close(outputStream);
        StreamUtils.close(inputStream);
    }

    public void decrypt(InputStream inputStream, OutputStream outputStream, String password) {
        try {
            byte[] salt = new byte[16];
            inputStream.read(salt, 0, 16);
            byte[] iv = new byte[16];
            inputStream.read(iv, 0, 16);
            PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt, 65536, 128);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.secretKeyFactory.generateSecret(keySpec).getEncoded(), "AES");
            this.cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(iv));
            this.doCrypto(inputStream, outputStream);
        }
        catch (Exception exception) {
            logger.error("Could not decrypt file: %s", exception.getMessage());
            logger.logExceptionIfDebugEnabled(exception);
        }
    }

    private void doCrypto(InputStream inputStream, OutputStream outputStream) throws IOException, IllegalBlockSizeException, BadPaddingException {
        byte[] output;
        int bytesRead;
        byte[] input = new byte[8192];
        while ((bytesRead = inputStream.read(input)) != -1) {
            output = this.cipher.update(input, 0, bytesRead);
            if (output == null) continue;
            outputStream.write(output);
        }
        output = this.cipher.doFinal();
        if (output != null) {
            outputStream.write(output);
        }
        outputStream.flush();
    }
}

