/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.collection;

import at.mrdevelopment.toolkit.collection.PartitionedListIterator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class PartitionedListIteratorTest {
    @Test
    public void test() {
        ArrayList testList = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7"});
        Iterable partitions = PartitionedListIterator.createPartitions(testList, 2);
        Iterator iterator = partitions.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((long)2L, (long)iterator.next().size());
        Assert.assertEquals((long)2L, (long)iterator.next().size());
        Assert.assertEquals((long)2L, (long)iterator.next().size());
        Assert.assertEquals((long)1L, (long)iterator.next().size());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testEmptyList() {
        List testList = Collections.emptyList();
        Iterable partitions = PartitionedListIterator.createPartitions(testList, 2);
        Assert.assertFalse((boolean)partitions.iterator().hasNext());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testZeroPartitionSize() {
        ArrayList testArray = Lists.newArrayList((Object[])new String[]{"1", "2", "3"});
        PartitionedListIterator.createPartitions(testArray, 0).iterator();
    }
}

