/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.collection;

import java.util.concurrent.atomic.AtomicLong;

public class FIFOEntry<E extends Comparable<? super E>>
implements Comparable<FIFOEntry<E>> {
    private static final AtomicLong SEQUENCE = new AtomicLong();
    private final long sequenceNumber = SEQUENCE.getAndIncrement();
    private final E entry;

    public FIFOEntry(E entry) {
        this.entry = entry;
    }

    public E getEntry() {
        return this.entry;
    }

    @Override
    public int compareTo(FIFOEntry<E> other) {
        int res = this.entry.compareTo(other.entry);
        if (res == 0 && other.entry != this.entry) {
            res = this.sequenceNumber < other.sequenceNumber ? -1 : 1;
        }
        return res;
    }
}

