/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.cloud;

import at.mrdevelopment.esl.toolkit.file.FileDeleter;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.archive.TarArchive;
import at.mrdevelopment.toolkit.archive.XzArchive;
import at.mrdevelopment.toolkit.checksum.ChecksumMismatchException;
import at.mrdevelopment.toolkit.checksum.MD5;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.RetryExponentialRetry;
import com.microsoft.azure.storage.RetryPolicyFactory;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlobDirectory;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.ListBlobItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.commons.io.FilenameUtils;
import org.joda.time.DateTime;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AzureManager {
    private static final String CLOUD_BLOB_CONNECTION_STRING = "DefaultEndpointsProtocol=https;AccountName=imagotagarchivestorage;AccountKey=WDBraIdEC4klvaz6VNY8mY+QdZ0aSxy8mH3THlnI67lGMC5zGOfiFe7atD4TetwVcG+lxHbmnjYSAiKmlWW3yQ==;BlobEndpoint=https://imagotagarchivestorage.blob.core.windows.net/;TableEndpoint=https://imagotagarchivestorage.table.core.windows.net/;QueueEndpoint=https://imagotagarchivestorage.queue.core.windows.net/;FileEndpoint=https://imagotagarchivestorage.file.core.windows.net/";
    private static final String CLOUD_BLOB_CONTAINER_NAME = "upload";
    private final String storageConnectionString;
    private final String containerName;

    public static void main(String[] args) throws InitializationException, IOException {
        AzureManager azureManager = new AzureManager();
        OptionParser optionParser = new OptionParser();
        OptionSpecBuilder print = optionParser.accepts("print");
        ArgumentAcceptingOptionSpec printSystemSerial = optionParser.accepts("printSystemSerial").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec printDatabaseId = optionParser.accepts("printDatabaseId").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec storeFilename = optionParser.accepts("store").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec deleteFilename = optionParser.accepts("delete").withRequiredArg().ofType(String.class);
        OptionSpecBuilder really = optionParser.accepts("really");
        ArgumentAcceptingOptionSpec downloadFilename = optionParser.accepts("download").withRequiredArg().ofType(String.class);
        OptionSpecBuilder downloadAll = optionParser.accepts("downloadAll");
        ArgumentAcceptingOptionSpec downloadDirectory = optionParser.accepts("downloadDirectory").withRequiredArg().ofType(String.class);
        OptionSet options = optionParser.parse(args);
        if (options.has((OptionSpec)print)) {
            azureManager.printCloudContent(System.out, true);
        } else if (options.has((OptionSpec)printSystemSerial)) {
            String systemSerial = (String)options.valueOf((OptionSpec)printSystemSerial);
            azureManager.printCloudContentOfKey(System.out, "system-serial", systemSerial);
        } else if (options.has((OptionSpec)printDatabaseId)) {
            String databaseId = (String)options.valueOf((OptionSpec)printDatabaseId);
            azureManager.printCloudContentOfKey(System.out, "database-id", databaseId);
        } else if (options.has((OptionSpec)storeFilename)) {
            String filename = (String)options.valueOf((OptionSpec)storeFilename);
            azureManager.store(new File(filename));
        } else if (options.has((OptionSpec)deleteFilename)) {
            String filename = (String)options.valueOf((OptionSpec)deleteFilename);
            azureManager.delete(filename, options.has((OptionSpec)really));
        } else if (options.has((OptionSpec)downloadFilename) && options.has((OptionSpec)downloadDirectory)) {
            String filename = (String)options.valueOf((OptionSpec)downloadFilename);
            String directory = (String)options.valueOf((OptionSpec)downloadDirectory);
            azureManager.download(filename, new File(directory));
        } else if (options.has((OptionSpec)downloadAll) && options.has((OptionSpec)downloadDirectory)) {
            String directory = (String)options.valueOf((OptionSpec)downloadDirectory);
            azureManager.downloadAll(new File(directory));
        } else {
            System.err.println("Invalid arguments");
            optionParser.printHelpOn((OutputStream)System.err);
        }
    }

    public AzureManager() {
        this.storageConnectionString = CLOUD_BLOB_CONNECTION_STRING;
        this.containerName = CLOUD_BLOB_CONTAINER_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printCloudContent(OutputStream outputStream, boolean showInfo) throws InitializationException {
        try {
            CloudStorageAccount storageAccount = CloudStorageAccount.parse((String)this.storageConnectionString);
            CloudBlobClient blobClient = storageAccount.createCloudBlobClient();
            CloudBlobContainer upload = blobClient.getContainerReference(this.containerName);
            Iterable blobs = upload.listBlobs();
            Iterable containers = upload.listContainers();
            PrintStream printStream = new PrintStream(outputStream);
            for (CloudBlobContainer container : containers) {
                printStream.println("container: " + container.getUri());
            }
            int directories = 0;
            int totalArchives = 0;
            long totalSize = 0L;
            long totalBytesDownloaded = 0L;
            for (ListBlobItem blob : blobs) {
                if (!(blob instanceof CloudBlobDirectory)) continue;
                ++directories;
                printStream.println("directory: " + blob.getUri());
                Iterable listBlobs = ((CloudBlobDirectory)blob).listBlobs();
                Iterator iterator = listBlobs.iterator();
                int numberOfFiles = 0;
                long minLength = Long.MAX_VALUE;
                CloudBlob minBlob = null;
                while (iterator.hasNext()) {
                    ListBlobItem next = (ListBlobItem)iterator.next();
                    long length = 0L;
                    if (next instanceof CloudBlob) {
                        BlobProperties properties = ((CloudBlob)next).getProperties();
                        length = properties.getLength();
                        totalSize += length;
                        if (length < minLength) {
                            minLength = length;
                            minBlob = (CloudBlob)next;
                        }
                    }
                    printStream.println(String.format("      %3d: %s %10.2f MB", ++numberOfFiles, next.getUri(), (double)length / 1024.0 / 1024.0));
                }
                totalArchives += numberOfFiles;
                if (minBlob == null) continue;
                String name = minBlob.getName();
                String dir = System.getProperty("java.io.tmpdir");
                File tmpFile = new File(dir, name.substring(name.lastIndexOf("/")));
                FileOutputStream outStream = null;
                try {
                    outStream = new FileOutputStream(tmpFile);
                    minBlob.download((OutputStream)outStream);
                    totalBytesDownloaded += minLength;
                }
                catch (Throwable throwable) {
                    StreamUtils.close(outStream);
                    throw throwable;
                }
                StreamUtils.close(outStream);
                Map<String, String> status = this.getServiceStatusProperties(tmpFile);
                FileDeleter.deleteFile(tmpFile);
                if (!showInfo) continue;
                printStream.println(String.format("           %s, %s, %s, %s, %s", status.get("licensed-customer"), status.get("hostname"), status.get("ip-address"), status.get("mac-address"), status.get("system-serial")));
            }
            printStream.println(String.format("%n%s: %d archive%s in %d director%s", DateTime.now(), totalArchives, totalArchives == 1 ? "" : "s", directories, directories == 1 ? "y" : "ies"));
            printStream.println(String.format("Total size: %.2f MB", (double)totalSize / 1024.0 / 1024.0));
            printStream.println(String.format("downloaded %d Bytes (%.2f KB) (%.2f MB)", totalBytesDownloaded, (double)totalBytesDownloaded / 1024.0, (double)totalBytesDownloaded / 1024.0 / 1204.0));
        }
        catch (Exception exception) {
            throw new InitializationException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printCloudContentOfKey(OutputStream outputStream, String key, String value) throws InitializationException {
        try {
            CloudStorageAccount storageAccount = CloudStorageAccount.parse((String)this.storageConnectionString);
            CloudBlobClient blobClient = storageAccount.createCloudBlobClient();
            CloudBlobContainer upload = blobClient.getContainerReference(this.containerName);
            Iterable blobs = upload.listBlobs();
            PrintStream printStream = new PrintStream(outputStream);
            for (ListBlobItem blob : blobs) {
                if (!(blob instanceof CloudBlobDirectory)) continue;
                Iterable listBlobs = ((CloudBlobDirectory)blob).listBlobs();
                Iterator<ListBlobItem> iterator = listBlobs.iterator();
                ListBlobItem minBlob = this.getSmallestBlob(iterator);
                String name = ((CloudBlob)minBlob).getName();
                String dir = System.getProperty("java.io.tmpdir");
                File tmpFile = new File(dir, name.substring(name.lastIndexOf("/")));
                FileOutputStream outStream = null;
                try {
                    outStream = new FileOutputStream(tmpFile);
                    ((CloudBlob)minBlob).download((OutputStream)outStream);
                }
                catch (Throwable throwable) {
                    StreamUtils.close(outStream);
                    throw throwable;
                }
                StreamUtils.close(outStream);
                Map<String, String> status = this.getServiceStatusProperties(tmpFile);
                FileDeleter.deleteFile(tmpFile);
                if (!status.get(key).equals(value)) continue;
                this.printContentOfDirectory(((CloudBlobDirectory)blob).listBlobs().iterator(), printStream);
            }
        }
        catch (Exception exception) {
            throw new InitializationException(exception);
        }
    }

    public void printContentOfDirectory(Iterator<ListBlobItem> iterator, PrintStream printStream) throws URISyntaxException {
        while (iterator.hasNext()) {
            ListBlobItem next = iterator.next();
            BlobProperties properties = ((CloudBlob)next).getProperties();
            Date lastModified = properties.getLastModified();
            String name = ((CloudBlob)next).getName();
            printStream.println(String.format("%s - %s", name, lastModified.toString()));
        }
    }

    public void store(File file) throws InitializationException {
        try {
            BlobRequestOptions blobRequestOptions = new BlobRequestOptions();
            blobRequestOptions.setSingleBlobPutThresholdInBytes(Integer.valueOf(0x100000));
            blobRequestOptions.setConcurrentRequestCount(Integer.valueOf(1));
            blobRequestOptions.setRetryPolicyFactory((RetryPolicyFactory)new RetryExponentialRetry(0, 2, 2, 1));
            CloudStorageAccount storageAccount = CloudStorageAccount.parse((String)this.storageConnectionString);
            CloudBlobClient blobClient = storageAccount.createCloudBlobClient();
            blobClient.setDefaultRequestOptions(blobRequestOptions);
            CloudBlobContainer container = blobClient.getContainerReference(this.containerName);
            CloudBlobDirectory directoryReference = container.getDirectoryReference("temp");
            CloudBlockBlob blob = directoryReference.getBlockBlobReference(String.format("%s", file.getName()));
            blob.setStreamWriteSizeInBytes(262144);
            blob.uploadFromFile(file.getAbsolutePath());
        }
        catch (Exception exception) {
            throw new InitializationException(exception);
        }
    }

    public void delete(String filename) throws InitializationException {
        this.delete(filename, false);
    }

    public void delete(String filename, boolean really) throws InitializationException {
        try {
            if (really) {
                CloudStorageAccount storageAccount = CloudStorageAccount.parse((String)this.storageConnectionString);
                CloudBlobClient blobClient = storageAccount.createCloudBlobClient();
                CloudBlobContainer upload = blobClient.getContainerReference(this.containerName);
                Iterable blobs = upload.listBlobs();
                for (ListBlobItem blob : blobs) {
                    if (!(blob instanceof CloudBlobDirectory)) continue;
                    Iterable listBlobs = ((CloudBlobDirectory)blob).listBlobs();
                    for (ListBlobItem next : listBlobs) {
                        if (!(next instanceof CloudBlob) || !((CloudBlob)next).getName().contains(filename)) continue;
                        ((CloudBlob)next).delete();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new InitializationException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(String filename, File downloadDirectory) throws InitializationException {
        try {
            CloudStorageAccount storageAccount = CloudStorageAccount.parse((String)this.storageConnectionString);
            CloudBlobClient blobClient = storageAccount.createCloudBlobClient();
            CloudBlobContainer upload = blobClient.getContainerReference(this.containerName);
            Iterable blobs = upload.listBlobs();
            for (ListBlobItem blob : blobs) {
                if (!(blob instanceof CloudBlobDirectory)) continue;
                Iterable listBlobs = ((CloudBlobDirectory)blob).listBlobs();
                for (ListBlobItem next : listBlobs) {
                    if (!(next instanceof CloudBlob) || !((CloudBlob)next).getName().contains(filename)) continue;
                    FileOutputStream outStream = null;
                    try {
                        String name = ((CloudBlob)next).getName();
                        outStream = new FileOutputStream(new File(downloadDirectory, name.substring(name.lastIndexOf(47))));
                        ((CloudBlob)next).download((OutputStream)outStream);
                        StreamUtils.close(outStream);
                    }
                    catch (FileNotFoundException exception) {
                        exception.printStackTrace();
                    }
                    finally {
                        StreamUtils.close(outStream);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new InitializationException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadAll(File downloadDirectory) throws InitializationException {
        try {
            CloudStorageAccount storageAccount = CloudStorageAccount.parse((String)this.storageConnectionString);
            CloudBlobClient blobClient = storageAccount.createCloudBlobClient();
            CloudBlobContainer upload = blobClient.getContainerReference(this.containerName);
            Iterable blobs = upload.listBlobs();
            for (ListBlobItem blob : blobs) {
                if (!(blob instanceof CloudBlobDirectory)) continue;
                Iterable listBlobs = ((CloudBlobDirectory)blob).listBlobs();
                for (ListBlobItem next : listBlobs) {
                    if (!(next instanceof CloudBlob)) continue;
                    FileOutputStream outStream = null;
                    try {
                        String name = ((CloudBlob)next).getName();
                        String[] split = name.split("/");
                        File newDir = new File(downloadDirectory, split[0]);
                        newDir.mkdirs();
                        outStream = new FileOutputStream(new File(newDir, split[1]));
                        ((CloudBlob)next).download((OutputStream)outStream);
                        StreamUtils.close(outStream);
                    }
                    catch (FileNotFoundException exception) {
                        exception.printStackTrace();
                    }
                    finally {
                        StreamUtils.close(outStream);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new InitializationException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File decompressArchive(File compressedArchive) {
        XzArchive archive = new XzArchive();
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        File decompressedFile = new File(System.getProperty("java.io.tmpdir"), FilenameUtils.removeExtension((String)compressedArchive.getName()));
        try {
            decompressedFile.createNewFile();
            fileInputStream = new FileInputStream(compressedArchive);
            fileOutputStream = new FileOutputStream(decompressedFile);
            archive.readStreamFromArchive(fileInputStream, (OutputStream)fileOutputStream);
        }
        catch (Exception exception) {
            try {
                System.err.println(String.format("Could not decompress archive: %s", exception.getMessage()));
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                StreamUtils.close(fileOutputStream);
                StreamUtils.close(fileInputStream);
                throw throwable;
            }
            StreamUtils.close(fileOutputStream);
            StreamUtils.close(fileInputStream);
        }
        StreamUtils.close(fileOutputStream);
        StreamUtils.close(fileInputStream);
        return decompressedFile;
    }

    public void validateArchiveFiles(File folder) {
        if (folder != null && folder.exists() && folder.isDirectory()) {
            File[] archives;
            MD5 md5 = null;
            try {
                md5 = new MD5();
            }
            catch (NoSuchAlgorithmException exception) {
                System.err.println(exception.getMessage());
                exception.printStackTrace();
            }
            for (File file : archives = folder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".tar.xz");
                }
            })) {
                File decompressArchive = this.decompressArchive(file);
                String dir = System.getProperty("java.io.tmpdir");
                TarArchive.untarFiles(decompressArchive, new File(dir));
                File md5File = new File(dir, "md5sum.txt");
                try {
                    md5.verfiyChecksums(md5File);
                }
                catch (ChecksumMismatchException exception) {
                    System.err.println(exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }
    }

    private Map<String, String> parseServiceStatusProperties(InputStream xmlInputStream) throws SerializeException, InitializationException {
        Element root = new XMLToolkit().getDocumentRootFromInputStream(xmlInputStream);
        HashMap<String, String> serviceStatusProperties = new HashMap<String, String>();
        NodeList properties = root.getElementsByTagName("property");
        for (int index = 0; index < properties.getLength(); ++index) {
            Element propertyElement = (Element)properties.item(index);
            String key = propertyElement.getAttribute("key");
            String value = propertyElement.getTextContent();
            serviceStatusProperties.put(key, value);
        }
        return serviceStatusProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getServiceStatusProperties(File archiveFile) throws FileNotFoundException, SerializeException, InitializationException {
        Map<String, String> serviceStatusProperties = null;
        String dir = System.getProperty("java.io.tmpdir");
        File decompressArchive = null;
        FileInputStream inputStream = null;
        try {
            decompressArchive = this.decompressArchive(archiveFile);
            TarArchive.untarFiles(decompressArchive, new File(dir));
            File file = new File(dir, "servicestatus.xml.xz");
            File servicestatus = this.decompressArchive(file);
            inputStream = new FileInputStream(servicestatus);
            serviceStatusProperties = this.parseServiceStatusProperties(inputStream);
        }
        catch (Throwable throwable) {
            StreamUtils.close(inputStream);
            FileDeleter.deleteFile(decompressArchive);
            throw throwable;
        }
        StreamUtils.close(inputStream);
        FileDeleter.deleteFile(decompressArchive);
        return serviceStatusProperties;
    }

    private ListBlobItem getSmallestBlob(Iterator<ListBlobItem> iterator) {
        long minLength = Long.MAX_VALUE;
        CloudBlob minBlob = null;
        while (iterator.hasNext()) {
            BlobProperties properties;
            ListBlobItem next = iterator.next();
            long length = 0L;
            if (!(next instanceof CloudBlob) || (length = (properties = ((CloudBlob)next).getProperties()).getLength()) >= minLength) continue;
            minLength = length;
            minBlob = (CloudBlob)next;
        }
        return minBlob;
    }
}

