/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.checksum;

import at.mrdevelopment.toolkit.checksum.ChecksumMismatchException;
import at.mrdevelopment.toolkit.checksum.Digest;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class AbstractDigest
implements Digest {
    static ESLLogger logger = ESLLogger.getLogger(AbstractDigest.class);
    private final MessageDigest digest;

    public AbstractDigest(MessageDigest digest) {
        this.digest = digest;
    }

    @Override
    public String getChecksum(File file) throws IOException {
        return this.getChecksum(FileUtils.readFileToByteArray((File)file));
    }

    @Override
    public String getChecksum(InputStream inputStream) throws IOException {
        return this.getChecksum(IOUtils.toByteArray((InputStream)inputStream));
    }

    @Override
    public String getChecksum(String string) {
        return this.getChecksum(string.getBytes());
    }

    @Override
    public String getChecksum(byte[] byteArray) {
        this.digest.update(byteArray);
        String hexString = DatatypeConverter.printHexBinary((byte[])this.digest.digest());
        this.digest.reset();
        return hexString.toLowerCase();
    }

    @Override
    public String getChecksumLineOfFile(File file) throws IOException {
        return String.format("%s  %s%n", this.getChecksum(file), file.getName());
    }

    @Override
    public void verifyChecksum(File file, String checksum) throws ChecksumMismatchException, IOException {
        this.verifyChecksum(FileUtils.readFileToByteArray((File)file), checksum);
    }

    @Override
    public void verifyChecksum(InputStream inputStream, String checksum) throws ChecksumMismatchException, IOException {
        this.verifyChecksum(IOUtils.toByteArray((InputStream)inputStream), checksum);
    }

    @Override
    public void verifyChecksum(String string, String checksum) throws ChecksumMismatchException {
        this.verifyChecksum(string.getBytes(), checksum);
    }

    @Override
    public void verifyChecksum(byte[] byteArray, String checksum) throws ChecksumMismatchException {
        if (!checksum.equalsIgnoreCase(this.getChecksum(byteArray))) {
            throw new ChecksumMismatchException("Checksums do not match", new Object[0]);
        }
    }

    @Override
    public void verfiyChecksums(File checksumFile) throws ChecksumMismatchException {
        try {
            List lines = FileUtils.readLines((File)checksumFile);
            for (String line : lines) {
                String[] splitLine = line.split("\\s+");
                String checksum = splitLine[0];
                String filename = splitLine[1];
                this.checkLine(splitLine, 2);
                this.checkSumOfFile(checksum, new File(checksumFile.getParentFile(), filename));
            }
        }
        catch (IOException exception) {
            logger.error("Could not read file: ", exception.getMessage());
            logger.logExceptionIfDebugEnabled(exception);
        }
    }

    private void checkLine(String[] lines, int expectedFields) throws ChecksumMismatchException {
        if (lines.length != expectedFields) {
            throw new ChecksumMismatchException("Unexpected content in checksum file", new Object[0]);
        }
    }

    private void checkSumOfFile(String checksum, File file) throws ChecksumMismatchException {
        String calculatedChecksum = null;
        try {
            calculatedChecksum = this.getChecksum(file);
        }
        catch (IOException exception) {
            throw new ChecksumMismatchException(exception.getMessage(), new Object[0]);
        }
        if (!calculatedChecksum.equals(checksum)) {
            throw new ChecksumMismatchException("Invalid checksum of file: %s", file.getName());
        }
    }
}

