/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.camera;

import at.mrdevelopment.toolkit.camera.CivilUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.lti.civil.CaptureDeviceInfo;
import com.lti.civil.CaptureException;
import com.lti.civil.CaptureObserver;
import com.lti.civil.CaptureStream;
import com.lti.civil.CaptureSystem;
import com.lti.civil.DefaultCaptureSystemFactorySingleton;
import com.lti.civil.webcam.CivilJPEG_HTTPD;
import com.lti.civil.webcam.StoreMostRecent_CaptureObserver;
import java.io.IOException;
import java.util.List;

public class CustomJPEGServer {
    static ESLLogger logger;

    public CustomJPEGServer(int port, boolean hd, int deviceId) throws InterruptedException, IOException, CaptureException {
        this.init(port, hd, deviceId);
    }

    private void init(int port, boolean hd, int deviceId) throws InterruptedException, IOException, CaptureException {
        CaptureSystem system = DefaultCaptureSystemFactorySingleton.instance().createCaptureSystem();
        system.init();
        List list = system.getCaptureDeviceInfoList();
        if (deviceId < list.size()) {
            CaptureDeviceInfo info = (CaptureDeviceInfo)list.get(deviceId);
            logger.info("Device ID " + deviceId + ": " + info.getDeviceID());
            logger.info("Description " + deviceId + ": " + info.getDescription());
            CaptureStream captureStream = system.openCaptureDeviceStream(info.getDeviceID());
            if (hd) {
                CivilUtils.setVideoFormat(captureStream, 1200);
            }
            CivilJPEG_HTTPD.storeMostRecent_CaptureObserver = new StoreMostRecent_CaptureObserver();
            captureStream.setObserver((CaptureObserver)CivilJPEG_HTTPD.storeMostRecent_CaptureObserver);
            captureStream.start();
        }
        new CivilJPEG_HTTPD(port);
        while (true) {
            Thread.sleep(10000L);
        }
    }

    public static void main(String[] args) throws Exception {
        int port = 8079;
        int deviceNumber = 1;
        if (args.length == 2) {
            port = Integer.parseInt(args[0]);
            deviceNumber = Integer.parseInt(args[1]);
        } else if (args.length == 1) {
            logger.info("Usage: first argument port number, second argument device number (beginning from 1)");
        }
        logger.info("Starting webcam sever for device: %d at port %d", deviceNumber, port);
        boolean hd = true;
        new CustomJPEGServer(port, hd, deviceNumber - 1);
    }

    static {
        ESLLogger.initLogger(true);
        logger = ESLLogger.getLogger(CustomJPEGServer.class);
    }
}

