/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.camera;

import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.camera.CameraException;
import at.mrdevelopment.toolkit.camera.CivilUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.lti.civil.CaptureDeviceInfo;
import com.lti.civil.CaptureException;
import com.lti.civil.CaptureObserver;
import com.lti.civil.CaptureStream;
import com.lti.civil.CaptureSystem;
import com.lti.civil.DefaultCaptureSystemFactorySingleton;
import com.lti.civil.Image;
import com.lti.civil.awt.AWTImageConverter;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.util.List;

public class CameraCivil
implements Shutdownable {
    static ESLLogger logger;
    private static final int MINIMUM_CAPTURE_WIDTH_PX = 1200;
    private CaptureSystem system;
    private CaptureStream captureStream;
    private BufferedImage latestImage;
    private int deviceId;

    public CameraCivil() {
        this(0);
    }

    public CameraCivil(int deviceId) {
        this.deviceId = deviceId;
    }

    public void start() throws CameraException {
        try {
            this.system = DefaultCaptureSystemFactorySingleton.instance().createCaptureSystem();
            this.system.init();
            List list = this.system.getCaptureDeviceInfoList();
            int i = this.deviceId;
            if (i < list.size()) {
                CaptureDeviceInfo info = (CaptureDeviceInfo)list.get(i);
                String deviceID = info.getDeviceID();
                String description = info.getDescription();
                logger.info("Device ID " + i + ": " + deviceID);
                logger.info("Description " + i + ": " + description);
                CaptureStream captureStream = this.system.openCaptureDeviceStream(deviceID);
                captureStream.setObserver((CaptureObserver)new CaptureObserverImpl());
                CivilUtils.setVideoFormat(captureStream, 1200);
                captureStream.start();
            }
        }
        catch (CaptureException e) {
            throw new CameraException(e);
        }
    }

    @Override
    public void shutdown() {
        this.stop();
    }

    public void stop() {
        try {
            if (this.captureStream != null) {
                this.captureStream.stop();
                this.captureStream.dispose();
            }
            if (this.system != null) {
                this.system.dispose();
            }
        }
        catch (CaptureException e) {
            logger.logException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getLatestImage() {
        CameraCivil cameraCivil = this;
        synchronized (cameraCivil) {
            ColorModel cm = this.latestImage.getColorModel();
            boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
            WritableRaster raster = this.latestImage.copyData(null);
            return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLatestImage(BufferedImage image) {
        CameraCivil cameraCivil = this;
        synchronized (cameraCivil) {
            this.latestImage = image;
        }
    }

    static {
        ESLLogger.initLogger(true);
        logger = ESLLogger.getLogger(CameraCivil.class);
    }

    private class CaptureObserverImpl
    implements CaptureObserver {
        private CaptureObserverImpl() {
        }

        public void onError(CaptureStream sender, CaptureException exc) {
            logger.warn("Observer error: %s", exc.getMessage());
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }

        public void onNewImage(CaptureStream sender, Image image) {
            try {
                CameraCivil.this.setLatestImage(AWTImageConverter.toBufferedImage((Image)image));
            }
            catch (Exception exc) {
                logger.warn("Error setting latest image: %s", exc.getMessage());
                logger.logExceptionIfDebugEnabled(exc);
            }
        }
    }
}

