/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.barcodescanner.network;

import at.mrdevelopment.toolkit.barcodescanner.AbstractBarcodeScanner;
import at.mrdevelopment.toolkit.barcodescanner.Scan;
import at.mrdevelopment.toolkit.barcodescanner.image.BarcodeImageScanner;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NetworkBarcodeScanner
extends AbstractBarcodeScanner {
    static ESLLogger logger = ESLLogger.getLogger(NetworkBarcodeScanner.class);
    private static final int DEFAULT_RETRY_COUNT = 10;
    private String targetURL;
    private BarcodeImageScanner barcodeImageScanner;
    private int retryCount = 1;

    public NetworkBarcodeScanner(String targetURL) {
        this(targetURL, 10);
    }

    public NetworkBarcodeScanner(String targetURL, int retryCount) {
        this.targetURL = targetURL;
        this.barcodeImageScanner = BarcodeImageScanner.createQrCodeScanner();
        this.retryCount = retryCount;
    }

    public String getNetworkScannerURL() {
        return this.targetURL;
    }

    public List<Scan> scanBarcodes() {
        this.refreshWebcamImage();
        List<Scan> scans = null;
        try {
            for (int i = 0; scans == null && i < this.retryCount; ++i) {
                scans = this.barcodeImageScanner.scan(new URL(this.targetURL));
            }
            if (scans != null && !scans.isEmpty()) {
                return scans;
            }
        }
        catch (MalformedURLException e) {
            logger.logException(e);
        }
        catch (IOException e) {
            logger.logException(e);
        }
        return scans;
    }

    public Scan scanSpecificBarcode(String content, String delimiter) {
        Scan almostEqualScan = null;
        List<Scan> scans = null;
        this.refreshWebcamImage();
        try {
            for (int i = 0; i < this.retryCount; ++i) {
                scans = i == this.retryCount - 1 ? this.barcodeImageScanner.scan(new URL(this.targetURL)) : this.barcodeImageScanner.scan(new URL(this.targetURL));
                if (scans == null || scans.size() <= 0) continue;
                for (Scan scan : scans) {
                    if (scan.getData().equals(content)) {
                        return scan;
                    }
                    String scanPart = scan.getData().split(delimiter)[0];
                    if (!content.contains(scanPart)) continue;
                    almostEqualScan = scan;
                }
            }
        }
        catch (MalformedURLException exc) {
            logger.logException(exc);
            return new Scan(0L, "no scan", "no type", null);
        }
        catch (IOException exc) {
            logger.logException(exc);
            return new Scan(0L, "no scan", "no type", null);
        }
        if (almostEqualScan == null) {
            long scanCount = 0L;
            if (scans != null) {
                scanCount = scans.size();
            }
            almostEqualScan = new Scan(scanCount, "no scan", "no type", null);
        }
        return almostEqualScan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Scan> scanSpecificBarcodes(List<String> content, String delimiter) {
        Image image;
        HashMap<String, Scan> matchingScans;
        block17: {
            List<Scan> scans = null;
            matchingScans = new HashMap<String, Scan>();
            image = null;
            this.refreshWebcamImage();
            try {
                for (int i = 0; i < this.retryCount; ++i) {
                    scans = i == this.retryCount - 1 ? this.barcodeImageScanner.scan(new URL(this.targetURL)) : this.barcodeImageScanner.scan(new URL(this.targetURL));
                    if (scans != null && scans.size() > 0 && !scans.get(0).getData().equals("no scan")) {
                        for (Scan scan : scans) {
                            for (String message : content) {
                                if (scan.getData().equals(message)) {
                                    matchingScans.put(message, scan);
                                    continue;
                                }
                                String scanPart = scan.getData().split(delimiter)[0];
                                if (!message.contains(scanPart) || (!matchingScans.containsKey(message) || matchingScans.get(message).getData().equals(message)) && matchingScans.containsKey(message)) continue;
                                matchingScans.put(message, scan);
                            }
                        }
                        image = scans.get(0).getImage();
                    } else if (scans != null && scans.size() > 0 && scans.get(0).getData().equals("no scan")) {
                        for (String message : content) {
                            if (matchingScans.containsKey(message)) continue;
                            matchingScans.put(message, scans.get(0));
                        }
                    }
                    scans = null;
                }
            }
            catch (MalformedURLException exc) {
                logger.logException(exc);
            }
            catch (IOException exc) {
                logger.logException(exc);
            }
            finally {
                if (matchingScans.size() == content.size()) break block17;
                for (String message : content) {
                    if (matchingScans.containsKey(message)) continue;
                    matchingScans.put(message, new Scan(0L, "no scan", "no type", (BufferedImage)image));
                }
            }
        }
        if (image != null) {
            image.flush();
            image = null;
        }
        return matchingScans;
    }

    private void refreshWebcamImage() {
        for (int i = 0; i < 5; ++i) {
            try {
                this.barcodeImageScanner.scan(new URL(this.targetURL));
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException ignore) {
                continue;
            }
            catch (MalformedURLException ignore) {
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

