/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.barcodescanner;

import at.mrdevelopment.toolkit.barcodescanner.AwaitScan;
import at.mrdevelopment.toolkit.barcodescanner.Scan;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.HashMap;
import java.util.Map;

public class ScanMemory {
    static ESLLogger logger = ESLLogger.getLogger(ScanMemory.class);
    private Map<String, AwaitScan> awaitedScans = new HashMap<String, AwaitScan>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scan waitAndGetAwaitedScan(String scanData, long timeout) {
        long start = System.currentTimeMillis();
        while (true) {
            long now;
            if ((now = System.currentTimeMillis()) - start > timeout) {
                logger.warn("Scanner timed out after " + (now - start) + " milliseconds");
                return null;
            }
            Map<String, AwaitScan> map = this.awaitedScans;
            synchronized (map) {
                if (this.awaitedScans.containsKey(scanData) && this.awaitedScans.get(scanData).hasArrived()) {
                    return this.awaitedScans.get(scanData).getScan();
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.logException(e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitScan(String scanData) {
        Map<String, AwaitScan> map = this.awaitedScans;
        synchronized (map) {
            if (!this.awaitedScans.containsKey(scanData)) {
                this.awaitedScans.put(scanData, new AwaitScan(scanData));
            } else {
                this.awaitedScans.get(scanData).await();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanOccured(Scan scan) {
        String scanDataStr = scan.getData();
        Map<String, AwaitScan> map = this.awaitedScans;
        synchronized (map) {
            if (!this.awaitedScans.containsKey(scanDataStr)) {
                this.awaitedScans.put(scanDataStr, new AwaitScan(scanDataStr));
            }
            this.awaitedScans.get(scanDataStr).reportScan(scan);
        }
    }
}

