/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.barcode.specific;

import at.mrdevelopment.toolkit.barcode.Barcode1D;
import at.mrdevelopment.toolkit.barcode.BarcodeException;
import at.mrdevelopment.toolkit.barcode.BarcodeUtils;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

@TemplateElementType(type=TemplateNode.BARCODE_USPS4CB)
public class USPS4CBCode
extends Barcode1D {
    private static final String B4J_IDENTIFIER = "usps4cb";

    public USPS4CBCode() throws OptionException {
        super((Class<? extends Barcode1D>)USPS4CBCode.class);
    }

    public USPS4CBCode(Map<String, Option<?>> options) throws OptionException {
        super(options);
    }

    @Override
    protected Configuration createBarcodeConfiguration(double moduleWidth, double height) throws BarcodeException, OptionException {
        DefaultConfiguration barcodeConf = new DefaultConfiguration("barcode");
        DefaultConfiguration tagTypeConf = new DefaultConfiguration(B4J_IDENTIFIER);
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("module-width", moduleWidth + "mm", new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("height", height + "mm", new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("quiet-zone", "" + this.getQuietZoneFactor() + "mw", "enabled", this.isQuietZoneEnabled() ? "true" : "false"));
        DefaultConfiguration humanReadableConfig = this.isHumanReadableEnabled() ? BarcodeUtils.createBasicHumanReadableConfiguration(this.getFontSizePt(), this.getFontName(), this.getHumanReadablePlacement()) : BarcodeUtils.createBasicDisabledHumanReadableConfiguration();
        tagTypeConf.addChild((Configuration)humanReadableConfig);
        barcodeConf.addChild((Configuration)tagTypeConf);
        return barcodeConf;
    }

    @Override
    public String getDefaultMessage() {
        return "12663453453256245345";
    }
}

