/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.barcode.specific;

import at.mrdevelopment.toolkit.barcode.Barcode1D;
import at.mrdevelopment.toolkit.barcode.BarcodeException;
import at.mrdevelopment.toolkit.barcode.BarcodeUtils;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

@TemplateElementType(type=TemplateNode.BARCODE_INTL2OF5)
public class Intl2of5Code
extends Barcode1D {
    private static final String B4J_IDENTIFIER = "intl2of5";
    public static final double DEFAULT_WIDE_FACTOR = 3.0;
    public static final Barcode1D.ChecksumMode DEFAULT_CHECKSUM_MODE = Barcode1D.ChecksumMode.IGNORE;
    public static final boolean DEFAULT_DISPLAY_CHECKSUM = false;

    public Intl2of5Code() throws OptionException {
        super((Class<? extends Barcode1D>)Intl2of5Code.class);
    }

    public Intl2of5Code(Map<String, Option<?>> options) throws OptionException {
        super(options);
    }

    @Override
    protected Configuration createBarcodeConfiguration(double moduleWidth, double height) throws BarcodeException, OptionException {
        DefaultConfiguration barcodeConf = new DefaultConfiguration("barcode");
        DefaultConfiguration tagTypeConf = new DefaultConfiguration(B4J_IDENTIFIER);
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("module-width", moduleWidth + "mm", new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("height", height + "mm", new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("checksum", BarcodeUtils.checksumModeToB4JString(this.getChecksumMode()), new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("quiet-zone", "" + this.getQuietZoneFactor() + "mw", "enabled", this.isQuietZoneEnabled() ? "true" : "false"));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("wide-factor", "" + this.getWideFactor(), new String[0]));
        DefaultConfiguration humanReadableConfig = this.isHumanReadableEnabled() ? BarcodeUtils.createBasicHumanReadableConfiguration(this.getFontSizePt(), this.getFontName(), this.getHumanReadablePlacement()) : BarcodeUtils.createBasicDisabledHumanReadableConfiguration();
        humanReadableConfig.addChild(BarcodeUtils.getBarcode4JConfigurationElement("display-checksum", this.isDisplayChecksum() ? "true" : "false", new String[0]));
        tagTypeConf.addChild((Configuration)humanReadableConfig);
        barcodeConf.addChild((Configuration)tagTypeConf);
        return barcodeConf;
    }

    public double getWideFactor() throws OptionException {
        return this.optionContainer.getDoubleOptionValue("wideFactor");
    }

    public void setWideFactor(double wideFactor) throws OptionException {
        this.optionContainer.setOption("wideFactor", wideFactor);
    }

    public boolean isDisplayChecksum() throws OptionException {
        return this.optionContainer.getBooleanOptionValue("displayChecksum");
    }

    public void setDisplayChecksum(boolean displayChecksum) throws OptionException {
        this.optionContainer.setOption("displayChecksum", displayChecksum);
    }

    public Barcode1D.ChecksumMode getChecksumMode() throws OptionException {
        return this.optionContainer.getChecksumModeOptionValue("checksumMode");
    }

    public void setChecksumMode(Barcode1D.ChecksumMode checksumMode) throws OptionException {
        this.optionContainer.setOption("checksumMode", checksumMode);
    }

    @Override
    public String getDefaultMessage() {
        return "123000000123";
    }
}

