/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.barcode;

import at.mrdevelopment.toolkit.barcode.Barcode1D;
import at.mrdevelopment.toolkit.barcode.BarcodeImage;
import at.mrdevelopment.toolkit.barcode.specific.DataMatrixCode;
import at.mrdevelopment.toolkit.math.Conversion;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.BarcodeException;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.BarcodeUtil;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;

public class BarcodeUtils {
    public static final String B4J_BARCODE = "barcode";
    public static final String B4J_MODULE_WIDTH = "module-width";
    public static final String B4J_HEIGHT = "height";
    public static final String B4J_HUMAN_READABLE = "human-readable";
    public static final String B4J_BEARER_BAR_WIDTH = "bearer-bar-width";
    public static final String B4J_BEARER_BOX = "bearer-box";
    public static final String B4J_WIDE_FACTOR = "wide-factor";
    public static final String B4J_PLACEMENT = "placement";
    public static final String B4J_QUIET_ZONE = "quiet-zone";
    public static final String B4J_VERTICAL_QUIET_ZONE = "quiet-zone";
    public static final String B4J_ROW_HEIGHT = "row-height";
    public static final String B4J_COLUMNS = "columns";
    public static final String B4J_MIN_COLUMNS = "min-columns";
    public static final String B4J_MAX_COLUMNS = "max-columns";
    public static final String B4J_MIN_ROWS = "min-rows";
    public static final String B4J_MAX_ROWS = "max-rows";
    public static final String B4J_EC_LEVEL = "ec-level";
    public static final String B4J_WIDTH_TO_HEIGHT_RATIO = "width-to-height-ratio";
    public static final String B4J_DISPLAY_START_STOP = "display-start-stop";
    public static final String B4J_DISPLAY_CHECKSUM = "display-checksum";
    public static final String B4J_CHECKSUM = "checksum";
    public static final String B4J_INTERCHAR_GAP_WIDTH = "interchar-gap-width";
    public static final String B4J_EXTENDED_CHARSET = "extended-charset";
    public static final String B4J_CODESETS = "codesets";
    public static final String B4J_TEMPLATE = "template";
    public static final String B4J_OMIT_BRACKETS = "omit-brackets";
    public static final String B4J_SHAPE = "shape";
    public static final String B4J_MIN_SYMBOL_SIZE = "min-symbol-size";
    public static final String B4J_MAX_SYMBOL_SIZE = "max-symbol-size";
    public static final String B4J_AUTO = "auto";
    public static final String B4J_ADD = "add";
    public static final String B4J_IGNORE = "ignore";
    public static final String B4J_CHECK = "check";
    public static final String B4J_ENABLED = "enabled";
    public static final String B4J_TRUE = "true";
    public static final String B4J_FALSE = "false";
    public static final String B4J_NONE = "none";
    public static final String B4J_BOTTOM = "bottom";
    public static final String B4J_TOP = "top";
    public static final String B4J_FONT_NAME = "font-name";
    public static final String B4J_FONT_SIZE = "font-size";
    public static final String B4J_FORCE_NONE = "force-none";
    public static final String B4J_FORCE_RECTANGLE = "force-rectangle";
    public static final String B4J_FORCE_SQUARE = "force-square";
    public static final String B4J_MW = "mw";
    public static final String B4J_MM = "mm";
    public static final String B4J_PT = "pt";
    public static final int DEFAULT_DPI = 152;

    private BarcodeUtils() {
    }

    public static BarcodeImage getBarcode4JCode(String message, Configuration configuration) throws ConfigurationException, BarcodeException, IOException {
        return BarcodeUtils.getBarcode4JCode(message, 152, 12, false, 0, configuration);
    }

    public static BarcodeImage getBarcode4JCode(String message, int dpi, int imageType, boolean antiAliasing, int rotation, Configuration configuration) throws ConfigurationException, BarcodeException, IOException {
        if (message == null || message.length() == 0) {
            throw new BarcodeException("Barcode content is not allowed to be empty");
        }
        BarcodeGenerator generator = BarcodeUtil.getInstance().createBarcodeGenerator(configuration);
        BitmapCanvasProvider provider = new BitmapCanvasProvider(dpi, imageType, antiAliasing, rotation);
        generator.generateBarcode((CanvasProvider)provider, message);
        provider.finish();
        BufferedImage barcodeImage = provider.getBufferedImage();
        return new BarcodeImage(barcodeImage, provider.getDimensions(), dpi);
    }

    public static BarcodeDimension getBarcode4JDimension(String message, Configuration configuration) throws ConfigurationException, IOException, BarcodeException {
        BarcodeGenerator generator = BarcodeUtil.getInstance().createBarcodeGenerator(configuration);
        BarcodeDimension dimension = generator.calcDimensions(message);
        return dimension;
    }

    public static Configuration getBarcode4JConfigurationElement(String name, String value, String ... attributes) {
        DefaultConfiguration configurationElement = new DefaultConfiguration(name);
        configurationElement.setValue(value);
        if (attributes != null && attributes.length > 1 && attributes.length % 2 == 0) {
            for (int i = 0; i < attributes.length - 1; i += 2) {
                configurationElement.setAttribute(attributes[i], attributes[i + 1]);
            }
        } else if (attributes.length % 2 != 0) {
            System.out.println("Warning: Invalid attribute array, attributes will be ignored.");
        }
        return configurationElement;
    }

    public static String checksumModeToB4JString(Barcode1D.ChecksumMode checksumMode) {
        String checksumModeString = B4J_IGNORE;
        switch (checksumMode) {
            case ADD: {
                checksumModeString = B4J_ADD;
                break;
            }
            case CHECK: {
                checksumModeString = B4J_CHECK;
                break;
            }
            case IGNORE: {
                checksumModeString = B4J_IGNORE;
                break;
            }
            case AUTO: {
                checksumModeString = B4J_AUTO;
                break;
            }
        }
        return checksumModeString;
    }

    public static String shapeToB4JString(DataMatrixCode.Shape shape) {
        String shapeString = B4J_FORCE_NONE;
        switch (shape) {
            case NONE: {
                shapeString = B4J_FORCE_NONE;
                break;
            }
            case RECTANGLE: {
                shapeString = B4J_FORCE_RECTANGLE;
                break;
            }
            case SQUARE: {
                shapeString = B4J_FORCE_SQUARE;
                break;
            }
        }
        return shapeString;
    }

    public static double calcModuleWidth(double totalWidth, int quietZoneFactor, BarcodeDimension initialDimension, double initialModuleWidth) throws ConfigurationException, BarcodeException, IOException, BarcodeException {
        double initialQuietZoneWidth = 2.0 * initialModuleWidth * (double)quietZoneFactor;
        double initialCodeWidth = initialDimension.getWidth();
        double initialTotalWidth = initialDimension.getWidthPlusQuiet();
        double initialWidthPlusQuiet = initialQuietZoneWidth + initialCodeWidth;
        return initialModuleWidth * ((totalWidth - (initialTotalWidth - initialWidthPlusQuiet)) / initialWidthPlusQuiet);
    }

    public static double calcPixelsPerModule(double moduleWidth) {
        return Conversion.getPixelCountForDistanceInMM(152, moduleWidth);
    }

    public static double calcHeight(double initialHeight, BarcodeDimension initialDimension) throws ConfigurationException, BarcodeException, IOException {
        return initialHeight + initialHeight - initialDimension.getHeightPlusQuiet();
    }

    public static DefaultConfiguration createBasicDisabledHumanReadableConfiguration() {
        DefaultConfiguration hrConf = new DefaultConfiguration(B4J_HUMAN_READABLE);
        hrConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement(B4J_PLACEMENT, B4J_NONE, new String[0]));
        return hrConf;
    }

    public static DefaultConfiguration createBasicHumanReadableConfiguration(int fontSizePt, String fontName, Barcode1D.HumanReadablePlacement humanReadablePlacement) {
        DefaultConfiguration hrConf = new DefaultConfiguration(B4J_HUMAN_READABLE);
        String placement = B4J_NONE;
        switch (humanReadablePlacement) {
            case BOTTOM: {
                placement = B4J_BOTTOM;
                break;
            }
            case TOP: {
                placement = B4J_TOP;
                break;
            }
        }
        hrConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement(B4J_PLACEMENT, placement, new String[0]));
        hrConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement(B4J_FONT_SIZE, fontSizePt + B4J_PT, new String[0]));
        hrConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement(B4J_FONT_NAME, fontName, new String[0]));
        return hrConf;
    }
}

