/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.barcode;

import at.mrdevelopment.toolkit.barcode.Barcode;
import at.mrdevelopment.toolkit.barcode.BarcodeException;
import at.mrdevelopment.toolkit.barcode.specific.CodabarCode;
import at.mrdevelopment.toolkit.barcode.specific.Code128Code;
import at.mrdevelopment.toolkit.barcode.specific.Code39Code;
import at.mrdevelopment.toolkit.barcode.specific.DataMatrixCode;
import at.mrdevelopment.toolkit.barcode.specific.EAN128Code;
import at.mrdevelopment.toolkit.barcode.specific.EAN13Code;
import at.mrdevelopment.toolkit.barcode.specific.EAN8Code;
import at.mrdevelopment.toolkit.barcode.specific.ITF14Code;
import at.mrdevelopment.toolkit.barcode.specific.Intl2of5Code;
import at.mrdevelopment.toolkit.barcode.specific.PDF417Code;
import at.mrdevelopment.toolkit.barcode.specific.PostnetCode;
import at.mrdevelopment.toolkit.barcode.specific.QRCode;
import at.mrdevelopment.toolkit.barcode.specific.RoyalMailCBCCode;
import at.mrdevelopment.toolkit.barcode.specific.UPCACode;
import at.mrdevelopment.toolkit.barcode.specific.UPCECode;
import at.mrdevelopment.toolkit.barcode.specific.USPS4CBCode;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.options.Option;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BarcodeFactory {
    private Map<String, Class<? extends Barcode>> barcodeTypes = new HashMap<String, Class<? extends Barcode>>();

    public BarcodeFactory() {
        this.registerBarcodeType(CodabarCode.class);
        this.registerBarcodeType(Code128Code.class);
        this.registerBarcodeType(Code39Code.class);
        this.registerBarcodeType(EAN13Code.class);
        this.registerBarcodeType(EAN8Code.class);
        this.registerBarcodeType(EAN128Code.class);
        this.registerBarcodeType(UPCACode.class);
        this.registerBarcodeType(UPCECode.class);
        this.registerBarcodeType(Intl2of5Code.class);
        this.registerBarcodeType(ITF14Code.class);
        this.registerBarcodeType(PostnetCode.class);
        this.registerBarcodeType(RoyalMailCBCCode.class);
        this.registerBarcodeType(USPS4CBCode.class);
        this.registerBarcodeType(PDF417Code.class);
        this.registerBarcodeType(DataMatrixCode.class);
        this.registerBarcodeType(QRCode.class);
    }

    private void registerBarcodeType(Class<? extends Barcode> barcodeClass) {
        String identifier = this.getBarcodeIdentifier(barcodeClass);
        this.barcodeTypes.put(identifier, barcodeClass);
    }

    private String getBarcodeIdentifier(Class<? extends Barcode> barcodeClass) {
        return barcodeClass.getAnnotation(TemplateElementType.class).type().getKey();
    }

    private Barcode loadBarcodeClass(Class<? extends Barcode> barcodeClass) {
        try {
            return barcodeClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Barcode loadBarcodeClass(Class<? extends Barcode> barcodeClass, Map<String, Option<?>> barcodeOptions) {
        try {
            Constructor<? extends Barcode> constructor = barcodeClass.getConstructor(Map.class);
            Barcode barcode = constructor.newInstance(barcodeOptions);
            return barcode;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Barcode getBarcode(String identifier, Map<String, Option<?>> barcodeOptions) throws BarcodeException {
        if (this.barcodeTypes.containsKey(identifier)) {
            return this.loadBarcodeClass(this.barcodeTypes.get(identifier), barcodeOptions);
        }
        throw new BarcodeException("Barcode type is not registered: [" + identifier + "]");
    }

    public Barcode getBarcode(String identifier) throws BarcodeException {
        if (this.barcodeTypes.containsKey(identifier)) {
            return this.loadBarcodeClass(this.barcodeTypes.get(identifier));
        }
        throw new BarcodeException("Barcode type is not registered: [" + identifier + "]");
    }

    public List<Class<? extends Barcode>> getBarcodeClasses() {
        ArrayList<Class<? extends Barcode>> barcodeClasses = new ArrayList<Class<? extends Barcode>>();
        barcodeClasses.addAll(this.barcodeTypes.values());
        return barcodeClasses;
    }

    public List<String> getBarcodeIdentifiers() {
        ArrayList<String> barcodeIdentifiers = new ArrayList<String>();
        barcodeIdentifiers.addAll(this.barcodeTypes.keySet());
        return barcodeIdentifiers;
    }
}

