/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.barcode;

import at.mrdevelopment.toolkit.barcode.BarcodeOptionContainer;
import at.mrdevelopment.toolkit.barcode.BarcodeOptionContainerImpl;
import at.mrdevelopment.toolkit.barcode.BarcodeRenderingResult;
import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.Element;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.options.OptionProvider;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Barcode
extends Element
implements OptionProvider<BarcodeOptionContainer> {
    protected BarcodeOptionContainerImpl optionContainer = new BarcodeOptionContainerImpl();
    public static final String FONT_SIZE_PT = "fontSizePt";
    public static final String FONT_NAME = "fontName";
    public static final String QUIET_ZONE_FACTOR = "quietZoneFactor";
    public static final String VERTICAL_QUIET_ZONE_FACTOR = "verticalQuietZoneFactor";
    public static final String QUIET_ZONE_ENABLED = "quietZoneEnabled";
    public static final String HUMAN_READABLE_ENABLED = "humanReadableEnabled";
    public static final String HUMAN_READABLE_PLACEMENT = "humanReadablePlacement";
    public static final String SCALE = "scale";
    public static final String AUTOSCALE = "autoscale";
    public static final String PADDED = "padded";
    public static final String CHECKSUM_MODE = "checksumMode";
    public static final String ERROR_CORRECTION_LEVEL = "errorCorrectionLevel";
    public static final String ROW_HEIGHT_RATIO = "rowHeightRatio";
    public static final String COLUMNS = "columns";
    public static final String MIN_COLUMNS = "minColumns";
    public static final String MAX_COLUMNS = "maxColumns";
    public static final String MIN_ROWS = "minRows";
    public static final String MAX_ROWS = "maxRows";
    public static final String EC_LEVEL = "ecLevel";
    public static final String WIDTH_TO_HEIGHT_RATIO = "widthToHeightRatio";
    public static final String BEARER_BAR_WIDTH = "bearerBarWidth";
    public static final String BEARER_BOX = "bearerBox";
    public static final String WIDE_FACTOR = "wideFactor";
    public static final String DISPLAY_CHECKSUM = "displayChecksum";
    public static final String TEMPLATE = "template";
    public static final String OMIT_BRACKETS = "omitBrackets";
    public static final String DISPLAY_START_STOP = "displayStartStop";
    public static final String INTERCHAR_GAP_WIDTH = "intercharGapWidth";
    public static final String EXTENDED_CHARSET = "extendedCharset";
    public static final String CODESETS = "codesets";
    public static final String AUTO_MODE = "autoMode";
    public static final String SHAPE = "shape";
    public static final String MIN_SYMBOL_SIZE_WIDTH = "minSymbolSizeWidth";
    public static final String MIN_SYMBOL_SIZE_HEIGHT = "minSymbolSizeHeight";
    public static final String MAX_SYMBOL_SIZE_WIDTH = "maxSymbolSizeWidth";
    public static final String MAX_SYMBOL_SIZE_HEIGHT = "maxSymbolSizeHeight";
    public static final int DUMMY_IMAGE_TYPE = 2;
    protected boolean verbose;

    public Barcode(Class<? extends Barcode> barcodeClass) throws OptionException {
        this(Barcode.createOptions(barcodeClass));
    }

    public Barcode(Map<String, Option<?>> options) throws OptionException {
        super(options);
        for (Option<?> option : options.values()) {
            this.optionContainer.registerOption(option);
        }
    }

    public abstract BarcodeRenderingResult render(String var1, int var2, int var3);

    public abstract String getDefaultMessage();

    public String getIdentifier() {
        return this.getClass().getAnnotation(TemplateElementType.class).type().getKey();
    }

    @Override
    public Collection<Attribute> getRequiredAttributes() {
        return Collections.emptyList();
    }

    protected BufferedImage createEmptyImage(int widthPx, int heightPx) {
        return ImageUtils.createImage(widthPx, heightPx, 2);
    }

    @Override
    public BarcodeOptionContainer getOptionContainer() {
        return this.optionContainer;
    }

    protected static Map<String, Option<?>> createOptions(Class<? extends Barcode> barcodeClass) {
        HashMap options = new HashMap();
        List<Attribute> attributeList = barcodeClass.getAnnotation(TemplateElementType.class).type().getAttributeList();
        for (Attribute attribute : attributeList) {
            try {
                options.put(attribute.getKey(), attribute.createOption());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return options;
    }

    public void setVerboseEnabled(boolean verbose) {
        this.verbose = verbose;
    }
}

