/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.archive;

import at.mrdevelopment.toolkit.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.IOUtils;

public class ZipStreamUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createZipStream(OutputStream outputStream, Map<String, ByteArrayInputStream> entries) throws IOException {
        ZipArchiveOutputStream zipArchiveOutputStream = null;
        try {
            zipArchiveOutputStream = new ZipArchiveOutputStream(outputStream);
            for (Map.Entry<String, ByteArrayInputStream> entry : entries.entrySet()) {
                ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(entry.getKey());
                zipArchiveEntry.setSize((long)entry.getValue().available());
                zipArchiveOutputStream.putArchiveEntry((ArchiveEntry)zipArchiveEntry);
                IOUtils.copy((InputStream)entry.getValue(), (OutputStream)zipArchiveOutputStream);
                zipArchiveOutputStream.closeArchiveEntry();
            }
            zipArchiveOutputStream.finish();
        }
        catch (Throwable throwable) {
            StreamUtils.close(zipArchiveOutputStream);
            throw throwable;
        }
        StreamUtils.close((OutputStream)zipArchiveOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, ByteArrayInputStream> unzipStream(InputStream inputStream) throws IOException {
        HashMap<String, ByteArrayInputStream> streams = new HashMap<String, ByteArrayInputStream>();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipEntry entry = null;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)zipInputStream));
                streams.put(entry.getName(), byteArrayInputStream);
            }
        }
        finally {
            StreamUtils.close(zipInputStream);
        }
        return streams;
    }
}

