/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.archive;

import at.mrdevelopment.esl.toolkit.file.FileDeleter;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.archive.AbstractArchive;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;

public class ZipArchive
extends AbstractArchive {
    static ESLLogger logger = ESLLogger.getLogger(ZipArchive.class);
    private static final String FILE_EXTENSION = "zip";

    @Override
    public void writeStreamToArchive(InputStream inputStream, File outputFile) {
    }

    @Override
    public void readStreamFromArchive(File inputFile, OutputStream outputStream) {
    }

    @Override
    public void readStreamFromArchive(InputStream inputStream, OutputStream outputStream) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFiles(Collection<File> inputFiles, File outputFile) {
        if (inputFiles != null && !inputFiles.isEmpty()) {
            ZipArchiveOutputStream zipArchiveOutputStream = null;
            try {
                zipArchiveOutputStream = new ZipArchiveOutputStream(outputFile);
                for (File file : inputFiles) {
                    ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(file.getName());
                    zipArchiveEntry.setSize(file.length());
                    zipArchiveOutputStream.putArchiveEntry((ArchiveEntry)zipArchiveEntry);
                    ZipArchive.copyFileToOutputStream(file, (OutputStream)zipArchiveOutputStream);
                    zipArchiveOutputStream.closeArchiveEntry();
                }
                zipArchiveOutputStream.finish();
            }
            catch (Exception exception) {
                try {
                    if (outputFile != null && outputFile.exists()) {
                        FileDeleter.deleteFile(outputFile);
                    }
                    logger.error("Could not create zip archive");
                    logger.logExceptionIfDebugEnabled(exception);
                }
                catch (Throwable throwable) {
                    StreamUtils.close(zipArchiveOutputStream);
                    throw throwable;
                }
                StreamUtils.close((OutputStream)zipArchiveOutputStream);
            }
            StreamUtils.close((OutputStream)zipArchiveOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipFiles(File inputFile, File outputDirectory) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(inputFile);
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)entries.nextElement();
                ZipArchive.copyInputStreamToFile(zipFile.getInputStream(zipArchiveEntry), ZipArchive.newFileMakeParentDirs(outputDirectory, zipArchiveEntry.getName()));
            }
        }
        catch (Exception exception) {
            try {
                logger.error("Could not read compressed file");
                logger.logExceptionIfDebugEnabled(exception);
            }
            catch (Throwable throwable) {
                ZipFile.closeQuietly(zipFile);
                throw throwable;
            }
            ZipFile.closeQuietly((ZipFile)zipFile);
        }
        ZipFile.closeQuietly((ZipFile)zipFile);
    }

    @Override
    public void writeFileToArchive(File inputFile, File outputFile) {
        ZipArchive.zipFiles(Arrays.asList(inputFile), outputFile);
    }

    @Override
    public ByteArrayOutputStream getFileContent(InputStream inputStream, String filename) {
        ZipArchiveInputStream zipArchiveInputStream = null;
        try {
            zipArchiveInputStream = new ZipArchiveInputStream(inputStream);
            ZipArchiveEntry zipArchiveEntry = null;
            while ((zipArchiveEntry = zipArchiveInputStream.getNextZipEntry()) != null) {
                if (!zipArchiveEntry.getName().equals(filename)) continue;
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)zipArchiveInputStream, (OutputStream)outputStream);
                return outputStream;
            }
        }
        catch (Exception exception) {
            logger.error("Could not read compressed file");
            logger.logExceptionIfDebugEnabled(exception);
        }
        return null;
    }

    @Override
    public String getExtension() {
        return FILE_EXTENSION;
    }
}

