/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.archive;

import at.mrdevelopment.esl.toolkit.file.FileDeleter;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.archive.Archive;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.XZInputStream;
import org.tukaani.xz.XZOutputStream;

public class XzArchive
implements Archive {
    static ESLLogger logger = ESLLogger.getLogger(XzArchive.class);
    private static final int COMPRESSION_LEVEL = 0;
    private static final int COMPRESSION_MODE = 1;
    private static final int DICTIONARY_SIZE = 4096;
    private static final String FILE_EXTENSION = "xz";
    private final LZMA2Options options = new LZMA2Options();

    public XzArchive() {
        this(0, 1, 4096);
    }

    public XzArchive(int compressionLevel, int compressionMode, int dictionarySize) {
        try {
            this.options.setPreset(compressionLevel);
            this.options.setMode(compressionMode);
            this.options.setDictSize(dictionarySize);
        }
        catch (UnsupportedOptionsException exception) {
            logger.error(String.format("Compression level %d not supported", compressionLevel));
            logger.logExceptionIfDebugEnabled(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStreamToArchive(InputStream inputStream, File outputFile) {
        FileOutputStream outputStream = null;
        XZOutputStream xzOutputStream = null;
        try {
            outputStream = new FileOutputStream(outputFile);
            xzOutputStream = new XZOutputStream((OutputStream)outputStream, (FilterOptions)this.options);
            IOUtils.copy((InputStream)inputStream, (OutputStream)xzOutputStream);
            xzOutputStream.finish();
        }
        catch (Exception exception) {
            try {
                if (outputFile != null && outputFile.exists()) {
                    FileDeleter.deleteFile(outputFile);
                }
                logger.error("Could not write compressed stream to file");
                logger.logExceptionIfDebugEnabled(exception);
            }
            catch (Throwable throwable) {
                StreamUtils.close(xzOutputStream);
                StreamUtils.close(outputStream);
                throw throwable;
            }
            StreamUtils.close((OutputStream)xzOutputStream);
            StreamUtils.close(outputStream);
        }
        StreamUtils.close((OutputStream)xzOutputStream);
        StreamUtils.close(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readStreamFromArchive(File inputFile, OutputStream outputStream) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(inputFile);
            this.readStreamFromArchive(inputStream, outputStream);
        }
        catch (FileNotFoundException exception) {
            try {
                logger.error("Could not read compressed file");
                logger.logExceptionIfDebugEnabled(exception);
            }
            catch (Throwable throwable) {
                StreamUtils.close(inputStream);
                throw throwable;
            }
            StreamUtils.close(inputStream);
        }
        StreamUtils.close(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readStreamFromArchive(InputStream inputStream, OutputStream outputStream) {
        XZInputStream xzInputStream = null;
        try {
            xzInputStream = new XZInputStream(inputStream);
            IOUtils.copy((InputStream)xzInputStream, (OutputStream)outputStream);
        }
        catch (Exception exception) {
            try {
                logger.error("Could not read compressed file");
                logger.logExceptionIfDebugEnabled(exception);
            }
            catch (Throwable throwable) {
                StreamUtils.close(xzInputStream);
                StreamUtils.close(inputStream);
                throw throwable;
            }
            StreamUtils.close((InputStream)xzInputStream);
            StreamUtils.close(inputStream);
        }
        StreamUtils.close((InputStream)xzInputStream);
        StreamUtils.close(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFileToArchive(File inputFile, File outputFile) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(inputFile);
            this.writeStreamToArchive(inputStream, outputFile);
        }
        catch (FileNotFoundException exception) {
            try {
                logger.error("Could not write compressed stream to file");
                logger.logExceptionIfDebugEnabled(exception);
            }
            catch (Throwable throwable) {
                StreamUtils.close(inputStream);
                throw throwable;
            }
            StreamUtils.close(inputStream);
        }
        StreamUtils.close(inputStream);
    }

    @Override
    public ByteArrayOutputStream getFileContent(InputStream inputStream, String filename) {
        return null;
    }

    @Override
    public String getExtension() {
        return FILE_EXTENSION;
    }
}

