/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.archive;

import at.mrdevelopment.esl.toolkit.file.FileDeleter;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.archive.AbstractArchive;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.IOUtils;

public class TarArchive
extends AbstractArchive {
    static ESLLogger logger = ESLLogger.getLogger(TarArchive.class);
    private static final String FILE_EXTENSION = "tar";

    @Override
    public void writeStreamToArchive(InputStream inputStream, File outputFile) {
    }

    @Override
    public void readStreamFromArchive(File inputFile, OutputStream outputStream) {
    }

    @Override
    public void readStreamFromArchive(InputStream inputStream, OutputStream outputStream) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tarFiles(Collection<File> inputFiles, File outputFile) {
        if (inputFiles != null && !inputFiles.isEmpty()) {
            FileOutputStream outputStream = null;
            TarArchiveOutputStream tarArchiveOutputStream = null;
            try {
                outputStream = new FileOutputStream(outputFile);
                tarArchiveOutputStream = new TarArchiveOutputStream((OutputStream)outputStream);
                for (File file : inputFiles) {
                    TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(file.getName());
                    tarArchiveEntry.setSize(file.length());
                    tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)tarArchiveEntry);
                    TarArchive.copyFileToOutputStream(file, (OutputStream)tarArchiveOutputStream);
                    tarArchiveOutputStream.closeArchiveEntry();
                }
                tarArchiveOutputStream.finish();
            }
            catch (IOException exception) {
                try {
                    if (outputFile != null && outputFile.exists()) {
                        FileDeleter.deleteFile(outputFile);
                    }
                    logger.error("Could not create tar archive");
                    logger.logExceptionIfDebugEnabled(exception);
                }
                catch (Throwable throwable) {
                    StreamUtils.close(tarArchiveOutputStream);
                    StreamUtils.close(outputStream);
                    throw throwable;
                }
                StreamUtils.close((OutputStream)tarArchiveOutputStream);
                StreamUtils.close(outputStream);
            }
            StreamUtils.close((OutputStream)tarArchiveOutputStream);
            StreamUtils.close(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void untarFiles(File inputFile, File outputDirectory) {
        FileInputStream inputStream = null;
        TarArchiveInputStream tarArchiveInputStream = null;
        try {
            inputStream = new FileInputStream(inputFile);
            tarArchiveInputStream = new TarArchiveInputStream((InputStream)inputStream);
            TarArchiveEntry tarArchiveEntry = null;
            while ((tarArchiveEntry = tarArchiveInputStream.getNextTarEntry()) != null) {
                TarArchive.copyInputStreamToFile((InputStream)tarArchiveInputStream, TarArchive.newFileMakeParentDirs(outputDirectory, tarArchiveEntry.getName()));
            }
        }
        catch (Exception exception) {
            try {
                logger.error("Could not read compressed file");
                logger.logExceptionIfDebugEnabled(exception);
            }
            catch (Throwable throwable) {
                StreamUtils.close(tarArchiveInputStream);
                StreamUtils.close(inputStream);
                throw throwable;
            }
            StreamUtils.close((InputStream)tarArchiveInputStream);
            StreamUtils.close(inputStream);
        }
        StreamUtils.close((InputStream)tarArchiveInputStream);
        StreamUtils.close(inputStream);
    }

    @Override
    public void writeFileToArchive(File inputFile, File outputFile) {
        TarArchive.tarFiles(Arrays.asList(inputFile), outputFile);
    }

    @Override
    public ByteArrayOutputStream getFileContent(InputStream inputStream, String filename) {
        TarArchiveInputStream tarArchiveInputStream = null;
        try {
            tarArchiveInputStream = new TarArchiveInputStream(inputStream);
            TarArchiveEntry tarArchiveEntry = null;
            while ((tarArchiveEntry = tarArchiveInputStream.getNextTarEntry()) != null) {
                if (!tarArchiveEntry.getName().equals(filename)) continue;
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)tarArchiveInputStream, (OutputStream)outputStream);
                return outputStream;
            }
        }
        catch (Exception exception) {
            logger.error("Could not read compressed file");
            logger.logExceptionIfDebugEnabled(exception);
        }
        return null;
    }

    @Override
    public String getExtension() {
        return FILE_EXTENSION;
    }
}

