/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.archive;

import at.mrdevelopment.esl.toolkit.file.FileDeleter;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.archive.Archive;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.IOUtils;

public class GzArchive
implements Archive {
    static ESLLogger logger = ESLLogger.getLogger(GzArchive.class);
    private static final String FILE_EXTENSION = "gz";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStreamToArchive(InputStream inputStream, File outputFile) {
        FileOutputStream outputStream = null;
        GzipCompressorOutputStream gzOutputStream = null;
        try {
            outputStream = new FileOutputStream(outputFile);
            gzOutputStream = new GzipCompressorOutputStream((OutputStream)outputStream);
            IOUtils.copy((InputStream)inputStream, (OutputStream)gzOutputStream);
            gzOutputStream.finish();
        }
        catch (Exception exception) {
            try {
                if (outputFile != null && outputFile.exists()) {
                    FileDeleter.deleteFile(outputFile);
                }
                logger.error("Could not write compressed stream to file");
                logger.logExceptionIfDebugEnabled(exception);
            }
            catch (Throwable throwable) {
                StreamUtils.close(gzOutputStream);
                StreamUtils.close(inputStream);
                throw throwable;
            }
            StreamUtils.close((OutputStream)gzOutputStream);
            StreamUtils.close(inputStream);
        }
        StreamUtils.close((OutputStream)gzOutputStream);
        StreamUtils.close(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readStreamFromArchive(File inputFile, OutputStream outputStream) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(inputFile);
            this.readStreamFromArchive(inputStream, outputStream);
        }
        catch (FileNotFoundException exception) {
            try {
                logger.error("Could not read compressed file");
                logger.logExceptionIfDebugEnabled(exception);
            }
            catch (Throwable throwable) {
                StreamUtils.close(inputStream);
                throw throwable;
            }
            StreamUtils.close(inputStream);
        }
        StreamUtils.close(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readStreamFromArchive(InputStream inputStream, OutputStream outputStream) {
        GzipCompressorInputStream gzInputStream = null;
        try {
            gzInputStream = new GzipCompressorInputStream(inputStream);
            IOUtils.copy((InputStream)gzInputStream, (OutputStream)outputStream);
        }
        catch (Exception exception) {
            try {
                logger.error("Could not read compressed file");
                logger.logExceptionIfDebugEnabled(exception);
            }
            catch (Throwable throwable) {
                StreamUtils.close(gzInputStream);
                StreamUtils.close(inputStream);
                throw throwable;
            }
            StreamUtils.close((InputStream)gzInputStream);
            StreamUtils.close(inputStream);
        }
        StreamUtils.close((InputStream)gzInputStream);
        StreamUtils.close(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFileToArchive(File inputFile, File outputFile) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(inputFile);
            this.writeStreamToArchive(inputStream, outputFile);
        }
        catch (FileNotFoundException exception) {
            try {
                logger.error("Could not write compressed stream to file");
                logger.logExceptionIfDebugEnabled(exception);
            }
            catch (Throwable throwable) {
                StreamUtils.close(inputStream);
                throw throwable;
            }
            StreamUtils.close(inputStream);
        }
        StreamUtils.close(inputStream);
    }

    @Override
    public ByteArrayOutputStream getFileContent(InputStream inputStream, String filename) {
        return null;
    }

    @Override
    public String getExtension() {
        return FILE_EXTENSION;
    }
}

