/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.appliance.led;

import at.mrdevelopment.toolkit.appliance.led.LedCommand;
import at.mrdevelopment.toolkit.led.LedBlinkingInterval;
import at.mrdevelopment.toolkit.led.LedStatus;

public class LedProcessBuilder {
    private static final String LED_CONTROL_EXECUTABLES_DIRECTORY = "/bin/esl/";
    private static final String EXECUTABLE_TEMPLATE = "/bin/esl/top_###top###_bottom_###bottom###";
    private static final String TOP_ON_BOTTOM_ON = "/bin/esl/top_###top###_bottom_###bottom###".replace("###top###", "on").replaceAll("###bottom###", "on");
    private static final String TOP_ON_BOTTOM_OFF = "/bin/esl/top_###top###_bottom_###bottom###".replace("###top###", "on").replaceAll("###bottom###", "off");
    private static final String TOP_OFF_BOTTOM_ON = "/bin/esl/top_###top###_bottom_###bottom###".replace("###top###", "off").replaceAll("###bottom###", "on");
    private static final String TOP_OFF_BOTTOM_OFF = "/bin/esl/top_###top###_bottom_###bottom###".replace("###top###", "off").replaceAll("###bottom###", "off");

    public static ProcessBuilder getLedProcessBuilder(LedStatus topLedStatus, LedStatus bottomLedStatus, LedStatus newLedStatus) {
        LedStatus.LedType ledType = newLedStatus.getLedType();
        LedStatus.LedState ledState = newLedStatus.getLedState();
        LedBlinkingInterval ledBlinkingInterval = newLedStatus.getLedBlinkingInterval();
        LedCommand ledCommand = new LedCommand();
        if (ledType == LedStatus.LedType.TOP) {
            ledCommand.addArgument(EXECUTABLE_TEMPLATE.replace("###top###", ledState.toString().toLowerCase()).replace("###bottom###", bottomLedStatus.getLedState().toString().toLowerCase()));
            if (ledState == LedStatus.LedState.BLINKING) {
                ledCommand.addArgument(ledBlinkingInterval.getBlinkingInterval());
            }
            if (bottomLedStatus.getLedState() == LedStatus.LedState.BLINKING) {
                ledCommand.addArgument(bottomLedStatus.getLedBlinkingInterval().getBlinkingInterval());
            }
        }
        if (ledType == LedStatus.LedType.BOTTOM) {
            ledCommand.addArgument(EXECUTABLE_TEMPLATE.replace("###top###", topLedStatus.getLedState().toString().toLowerCase()).replace("###bottom###", ledState.toString().toLowerCase()));
            if (topLedStatus.getLedState() == LedStatus.LedState.BLINKING) {
                ledCommand.addArgument(topLedStatus.getLedBlinkingInterval().getBlinkingInterval());
            }
            if (ledState == LedStatus.LedState.BLINKING) {
                ledCommand.addArgument(ledBlinkingInterval.getBlinkingInterval());
            }
        }
        return new ProcessBuilder(ledCommand.getCommand());
    }

    public static ProcessBuilder getLedProcessBuilderTurnOffAll() {
        return new ProcessBuilder(TOP_OFF_BOTTOM_OFF);
    }

    public static ProcessBuilder getLedProcessBuilderTurnOnAll() {
        return new ProcessBuilder(TOP_ON_BOTTOM_ON);
    }

    public static boolean isRestartable(String command) {
        return !command.equalsIgnoreCase(TOP_ON_BOTTOM_ON) && !command.equalsIgnoreCase(TOP_ON_BOTTOM_OFF) && !command.equalsIgnoreCase(TOP_OFF_BOTTOM_ON) && !command.equalsIgnoreCase(TOP_OFF_BOTTOM_OFF);
    }
}

