/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.appliance.disk;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.appliance.disk.DiskState;
import at.mrdevelopment.toolkit.appliance.disk.DiskStateParser;
import at.mrdevelopment.toolkit.appliance.disk.SMARTAttribute;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ISMARTDiskStateParser
implements DiskStateParser {
    private static final String TOOL_NAME = "Innodisk iSMART";
    private static final String ISMART_EXECUTABLE = "/bin/esl/iSMART_64";
    private static final String TOOL_INFORMATION_PATTERN = "\\* Innodisk iSMART V(.*?)\\s+.*";
    private static final String DISK_INFORMATION_PATTERN = "(.+): (.*?)\\s*|(Health) = (.+?)\\s*";
    private static final String SMART_ATTRIBUTES_PATTERN = "\\[(.+?)\\]\\s*(.+?)\\s*\\[(.+?)\\].*";
    private final Pattern toolInformationPattern = Pattern.compile("\\* Innodisk iSMART V(.*?)\\s+.*");
    private final Pattern diskInformationPattern = Pattern.compile("(.+): (.*?)\\s*|(Health) = (.+?)\\s*");
    private final Pattern smartAttributesPattern = Pattern.compile("\\[(.+?)\\]\\s*(.+?)\\s*\\[(.+?)\\].*");
    private final String deviceIdentifier;

    public ISMARTDiskStateParser(String deviceIdentifier) {
        this.deviceIdentifier = deviceIdentifier;
    }

    @Override
    public DiskState getDiskState() throws Exception {
        return this.parseISMART();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiskState parseISMART() throws InitializationException, IOException, InterruptedException {
        String toolVersion = "";
        HashMap<String, String> diskInformation = new HashMap<String, String>();
        HashMap<Long, SMARTAttribute> smartAttributes = new HashMap<Long, SMARTAttribute>();
        Process process = Runtime.getRuntime().exec(String.format("%s -d %s", ISMART_EXECUTABLE, this.deviceIdentifier));
        process.waitFor();
        InputStream inputStream = process.getInputStream();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                Matcher toolInformationMatcher = this.toolInformationPattern.matcher(line);
                Matcher diskInformationMatcher = this.diskInformationPattern.matcher(line);
                Matcher smartAttributesMatcher = this.smartAttributesPattern.matcher(line);
                if (toolInformationMatcher.matches()) {
                    toolVersion = toolInformationMatcher.group(1);
                }
                if (diskInformationMatcher.matches()) {
                    if (diskInformationMatcher.group(1) != null && diskInformationMatcher.group(2) != null) {
                        diskInformation.put(this.normalize(diskInformationMatcher.group(1)), this.normalize(diskInformationMatcher.group(2)));
                    } else {
                        diskInformation.put(this.normalize(diskInformationMatcher.group(3)), this.normalize(diskInformationMatcher.group(4)));
                    }
                }
                if (!smartAttributesMatcher.matches()) continue;
                Long id = Long.parseLong(smartAttributesMatcher.group(1), 16);
                smartAttributes.put(id, new SMARTAttribute(id, this.normalize(smartAttributesMatcher.group(2)), Long.parseLong(smartAttributesMatcher.group(3))));
            }
        }
        catch (Throwable throwable) {
            StreamUtils.close(bufferedReader);
            throw throwable;
        }
        StreamUtils.close(bufferedReader);
        if (diskInformation.isEmpty() && smartAttributes.isEmpty()) {
            throw new InitializationException(String.format("Failed to receive SMART information from %s", this.deviceIdentifier), new Object[0]);
        }
        return new DiskState(TOOL_NAME, toolVersion, diskInformation, smartAttributes);
    }

    private String normalize(String string) {
        return string.replace(' ', '_').trim();
    }
}

