/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.appliance.disk;

import at.mrdevelopment.toolkit.appliance.disk.SMARTAttribute;
import java.util.Map;

public class DiskState {
    private final String toolName;
    private final String toolVersion;
    private final Map<String, String> diskInformation;
    private final Map<Long, SMARTAttribute> smartAttributes;

    public DiskState(String toolName, String toolVersion, Map<String, String> diskInformation, Map<Long, SMARTAttribute> smartAttributes) {
        this.toolName = toolName;
        this.toolVersion = toolVersion;
        this.diskInformation = diskInformation;
        this.smartAttributes = smartAttributes;
    }

    public String getToolName() {
        return this.toolName;
    }

    public String getToolVersion() {
        return this.toolVersion;
    }

    public Map<String, String> getDiskInformation() {
        return this.diskInformation;
    }

    public Map<Long, SMARTAttribute> getSmartAttributes() {
        return this.smartAttributes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%s V%s%n", this.getToolName(), this.getToolVersion()));
        for (Map.Entry<String, String> diskInformationEntry : this.getDiskInformation().entrySet()) {
            builder.append(String.format("%s: %s%n", diskInformationEntry.getKey(), diskInformationEntry.getValue()));
        }
        for (SMARTAttribute smartAttribute : this.getSmartAttributes().values()) {
            builder.append(smartAttribute.toString());
        }
        return builder.toString();
    }
}

