/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.appliance;

import at.mrdevelopment.toolkit.file.FileUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.conn.ssl.NoopHostnameVerifier;

public class ESLServiceWatcher {
    static ESLLogger logger = ESLLogger.getLogger(ESLServiceWatcher.class);
    private static final String PS_CMD = "ps -p";
    private static final String PID_FILE = "/tmp/imagotag.pid";

    public static boolean isRunning() throws Exception {
        File pidFile = new File(PID_FILE);
        if (pidFile.exists()) {
            String line = FileUtils.read(pidFile);
            Process process = Runtime.getRuntime().exec(String.format("%s %s", PS_CMD, line));
            int exitCode = process.waitFor();
            return exitCode == 0;
        }
        return false;
    }

    public static boolean isUp(TrustManager trustManager, KeyManager[] keyManagers) {
        for (Integer port : Arrays.asList(8000, 8001, 80, 443)) {
            boolean htppServiceRunning = ESLServiceWatcher.isLocalhostListeningOnPort(trustManager, keyManagers, port);
            if (!htppServiceRunning) continue;
            return true;
        }
        return false;
    }

    private static boolean isLocalhostListeningOnPort(TrustManager trustManager, KeyManager[] keyManagers, int port) {
        return ESLServiceWatcher.canConnectWithHTTPS(trustManager, keyManagers, "localhost", port) || ESLServiceWatcher.canConnectWithHTTP("localhost", port);
    }

    private static boolean canConnectWithHTTPS(TrustManager trustManager, KeyManager[] keyManagers, String address, int port) {
        if (port == 80) {
            return false;
        }
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(keyManagers, new TrustManager[]{trustManager}, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
            URL url = new URL("https://" + address + ":" + port);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.connect();
            connection.getResponseCode();
            return true;
        }
        catch (UnknownHostException exception) {
            logger.error(exception.getMessage());
            logger.logException(exception);
        }
        catch (NoSuchAlgorithmException exception) {
            logger.error(exception.getMessage());
            logger.logExceptionIfDebugEnabled(exception);
        }
        catch (KeyManagementException exception) {
            logger.error(exception.getMessage());
            logger.logException(exception);
        }
        catch (IOException exception) {
            logger.warn(exception.getMessage());
            logger.logExceptionIfDebugEnabled(exception);
        }
        return false;
    }

    private static boolean canConnectWithHTTP(String address, int port) {
        if (port == 443) {
            return false;
        }
        try {
            URL url = new URL("http://" + address + ":" + port);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            connection.getResponseCode();
            return true;
        }
        catch (IOException exception) {
            logger.warn(exception.getMessage());
            logger.logExceptionIfDebugEnabled(exception);
            return false;
        }
    }
}

