/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.accesspoint.led;

import at.mrdevelopment.toolkit.accesspoint.led.LedController;
import at.mrdevelopment.toolkit.led.LedBlinkingInterval;
import at.mrdevelopment.toolkit.led.LedStatus;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;

public class LedGPIOController
implements LedController {
    static ESLLogger logger = ESLLogger.getLogger(LedGPIOController.class);
    private static final File GPIO_EXPORT_FILE = new File("/sys/class/gpio/export");
    private static final File GPIO_UNEXPORT_FILE = new File("/sys/class/gpio/unexport");
    private static final String GPIO_DIRECTORY = "/sys/class/gpio/gpio";
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Map<LedStatus.LedType, Integer> ledTypeToGPIO;
    private volatile boolean interrupted;
    private Future<?> future;

    public LedGPIOController(Map<LedStatus.LedType, Integer> ledTypeToGPIO) {
        this.ledTypeToGPIO = ledTypeToGPIO;
        for (Integer gpioNumber : ledTypeToGPIO.values()) {
            try {
                this.exportGPIO(gpioNumber);
            }
            catch (IOException exc) {
                logger.warn("Could not initialize GPIO %d", gpioNumber);
                logger.logExceptionIfDebugEnabled(exc);
            }
        }
    }

    @Override
    public void execute(final List<LedStatus> ledStates) {
        this.interrupted = false;
        this.future = this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ArrayList<BlinkingLedStatus> blinkingLeds = new ArrayList<BlinkingLedStatus>();
                for (LedStatus ledStatus : ledStates) {
                    if (ledStatus.getLedState().equals((Object)LedStatus.LedState.BLINKING)) {
                        if (ledStatus.getLedBlinkingInterval() == LedBlinkingInterval.OFF) {
                            LedGPIOController.this.handleLedStatus(new LedStatus(ledStatus.getLedType(), LedStatus.LedState.ON));
                            continue;
                        }
                        long blinkingInterval = ledStatus.getLedBlinkingInterval().getBlinkingInterval();
                        blinkingLeds.add(new BlinkingLedStatus(ledStatus, blinkingInterval));
                        continue;
                    }
                    LedGPIOController.this.handleLedStatus(ledStatus);
                }
                while (!LedGPIOController.this.interrupted) {
                    try {
                        for (BlinkingLedStatus blinkingLedStatus : blinkingLeds) {
                            LedGPIOController.this.handleLedStatus(blinkingLedStatus);
                        }
                        long sleepMillis = LedGPIOController.this.getSleepMillis(blinkingLeds);
                        Thread.sleep(sleepMillis);
                        LedGPIOController.this.setState(blinkingLeds, sleepMillis);
                    }
                    catch (InterruptedException exc) {
                        logger.info("Interrupting LedGPIOController");
                    }
                }
            }
        });
    }

    @Override
    public void shutdownAll() {
        this.setInterrupted(true);
        this.executor.shutdownNow();
        logger.info("Unexport gpio");
        for (Integer gpioNumber : this.ledTypeToGPIO.values()) {
            try {
                if (!new File(String.format("%s%d", GPIO_DIRECTORY, gpioNumber)).exists()) continue;
                this.off(gpioNumber);
                this.unexportGPIO(gpioNumber);
            }
            catch (IOException exc) {
                logger.warn("Could not shutdown GPIO %d", gpioNumber);
                logger.logExceptionIfDebugEnabled(exc);
            }
        }
    }

    public void setInterrupted(boolean interrupted) {
        logger.info("Set interrupted to %s", interrupted);
        this.interrupted = interrupted;
        if (this.future != null && interrupted) {
            try {
                this.future.get();
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            this.future.cancel(true);
        }
    }

    private void handleLedStatus(LedStatus status) {
        int gpioNumber = this.ledTypeToGPIO.get((Object)status.getLedType());
        try {
            switch (status.getLedState()) {
                case ON: {
                    this.on(gpioNumber);
                    break;
                }
                case OFF: {
                    this.off(gpioNumber);
                    break;
                }
            }
        }
        catch (IOException exc) {
            logger.error("Could not change status of gpio %d", gpioNumber);
            logger.logExceptionIfDebugEnabled(exc);
        }
    }

    private long getSleepMillis(List<BlinkingLedStatus> blinkingLeds) {
        long millis = LedBlinkingInterval.SLOW.getBlinkingInterval();
        for (BlinkingLedStatus status : blinkingLeds) {
            if (status.timeSettings.remainingMilliseconds >= millis) continue;
            millis = status.timeSettings.remainingMilliseconds;
        }
        for (BlinkingLedStatus status : blinkingLeds) {
            status.updateTimeSettings(millis);
        }
        return millis;
    }

    private void setState(List<BlinkingLedStatus> blinkingStates, long minRemainingMillis) {
        for (BlinkingLedStatus status : blinkingStates) {
            status.updateState(minRemainingMillis);
        }
    }

    private void on(int gpioNumber) throws IOException {
        this.setValue(gpioNumber, 1);
    }

    private void off(int gpioNumber) throws IOException {
        this.setValue(gpioNumber, 0);
    }

    private void exportGPIO(int gpioNumber) throws IOException {
        logger.info("Initialize gpio %d", gpioNumber);
        String gpioDirectoryPath = String.format("%s%d", GPIO_DIRECTORY, gpioNumber);
        File gpioDirectionFile = new File(String.format("%s/direction", gpioDirectoryPath));
        File gpioValueFile = new File(String.format("%s/value", gpioDirectoryPath));
        if (!new File(gpioDirectoryPath).exists()) {
            FileUtils.writeStringToFile((File)GPIO_EXPORT_FILE, (String)String.valueOf(gpioNumber), (boolean)false);
            FileUtils.writeStringToFile((File)gpioDirectionFile, (String)"out", (boolean)false);
            FileUtils.writeStringToFile((File)gpioValueFile, (String)"0", (boolean)false);
        }
    }

    private void unexportGPIO(int gpioNumber) throws IOException {
        logger.info("Unexport gpio %d", gpioNumber);
        FileUtils.writeStringToFile((File)GPIO_UNEXPORT_FILE, (String)String.valueOf(gpioNumber), (boolean)false);
    }

    private void setValue(int gpioNumber, int value) throws IOException {
        String gpioDirectoryPath = String.format("%s%d", GPIO_DIRECTORY, gpioNumber);
        File gpioValueFile = new File(String.format("%s/value", gpioDirectoryPath));
        FileUtils.writeStringToFile((File)gpioValueFile, (String)String.valueOf(value), (boolean)false);
    }

    private class BlinkingLedStatus
    extends LedStatus {
        private final TimeSettings timeSettings;

        private BlinkingLedStatus(LedStatus status, long millis) {
            super(status.getLedType(), LedStatus.LedState.ON);
            this.timeSettings = new TimeSettings(millis);
        }

        private void updateState(long millis) {
            if (this.timeSettings.remainingMillisecondsBefore <= millis) {
                switch (this.getLedState()) {
                    case ON: {
                        this.setLedState(LedStatus.LedState.OFF);
                        break;
                    }
                    case OFF: {
                        this.setLedState(LedStatus.LedState.ON);
                        break;
                    }
                }
            }
        }

        private void updateTimeSettings(long millis) {
            this.timeSettings.updateRemainingTime(millis);
        }
    }

    private class TimeSettings {
        private long milliseconds;
        private long remainingMilliseconds;
        private long remainingMillisecondsBefore;

        private TimeSettings(long millis) {
            this.milliseconds = millis;
            this.remainingMilliseconds = millis;
        }

        private void updateRemainingTime(long millis) {
            this.remainingMillisecondsBefore = this.remainingMilliseconds;
            this.remainingMilliseconds = this.remainingMilliseconds - millis <= 0L ? this.milliseconds : this.remainingMilliseconds - millis;
        }
    }
}

