/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit;

import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class Version
implements Comparable<Version> {
    private static ESLLogger logger = ESLLogger.getLogger(Version.class);
    public static final Version UNDEFINED = new Version(0, 0, 0);
    private final byte mainRelease;
    private final byte subRelease;
    private final byte patchLevel;
    private final int build;
    private final String branch;

    public static Version fromStringIgnoreBranch(String versionStr) {
        Version retValue = versionStr.contains("-") ? Version.fromStringWithoutBranch(versionStr.substring(0, versionStr.indexOf(45))) : Version.fromStringWithoutBranch(versionStr);
        return retValue;
    }

    public static Version fromStringWithoutBranch(String versionStr) {
        Version newVersion = null;
        try {
            String[] parts = StringUtils.split((String)versionStr, (char)'(');
            if (parts.length > 2) {
                logger.error("Malformed version string %s", versionStr);
                return newVersion;
            }
            String[] numbers = StringUtils.split((String)parts[0], (char)'.');
            if (numbers.length != 3) {
                logger.error("Malformed version string %s", versionStr);
                return newVersion;
            }
            byte mainRelease = Byte.parseByte(numbers[0].trim());
            byte subRelease = Byte.parseByte(numbers[1].trim());
            byte patchLevel = Byte.parseByte(numbers[2].trim());
            if (parts.length > 1) {
                short buildNumber = Short.parseShort(parts[1].replace(")", "").trim());
                newVersion = new Version(mainRelease, subRelease, patchLevel, buildNumber, null);
            } else {
                newVersion = new Version(mainRelease, subRelease, patchLevel);
            }
        }
        catch (Exception e) {
            logger.error("Malformed version string %s", versionStr);
            logger.logException(e);
        }
        return newVersion;
    }

    public static Version fromString(String versionString) throws IllegalArgumentException, NumberFormatException {
        byte patchLevel;
        String[] parts = StringUtils.split((String)versionString, (String)".");
        if (parts.length != 3) {
            throw new IllegalArgumentException(String.format("Malformed version string %s", versionString));
        }
        byte mainRelease = Byte.parseByte(parts[0]);
        byte subRelease = Byte.parseByte(parts[1]);
        String branch = null;
        Object[] patchLevelAndBranch = StringUtils.split((String)parts[2], (String)"-");
        if (patchLevelAndBranch.length == 1) {
            patchLevel = Byte.parseByte(patchLevelAndBranch[0]);
        } else if (patchLevelAndBranch.length > 1) {
            patchLevel = Byte.parseByte(patchLevelAndBranch[0]);
            branch = StringUtils.join((Object[])patchLevelAndBranch, (String)"-", (int)1, (int)patchLevelAndBranch.length);
        } else {
            throw new IllegalArgumentException(String.format("Malformed version string %s", versionString));
        }
        return new Version(mainRelease, subRelease, patchLevel, branch);
    }

    public static Version fromLancomVersion(String versionString) {
        Pattern pattern = Pattern.compile("(.*?)(\\d{1,3}[.]\\d{1,3}[.]\\d{1})(\\d{0,3})(.*)");
        Matcher matcher = pattern.matcher(versionString);
        if (matcher.find()) {
            Version version = Version.fromString(matcher.group(2));
            String buildString = matcher.group(3);
            if (!buildString.isEmpty()) {
                version = new Version(version, Integer.valueOf(buildString));
            }
            return version;
        }
        throw new IllegalArgumentException(String.format("Malformed version string %s", versionString));
    }

    public static Version fromByte(int versionByte) {
        byte mainRelease = (byte)((versionByte & 0xC0) >> 6);
        byte subRelease = (byte)((versionByte & 0x30) >> 4);
        byte patchLevel = (byte)(versionByte & 0xF);
        return new Version(mainRelease, subRelease, patchLevel);
    }

    public Version(byte mainRelease, byte subRelease, byte patchLevel) throws IllegalArgumentException {
        this(mainRelease, subRelease, patchLevel, 0, null);
    }

    public Version(byte mainRelease, byte subRelease, byte patchLevel, String branch) throws IllegalArgumentException {
        this(mainRelease, subRelease, patchLevel, 0, branch);
    }

    public Version(Version version, int build) {
        this(version.mainRelease, version.subRelease, version.patchLevel, build, version.branch);
    }

    public Version(byte mainRelease, byte subRelease, byte patchLevel, int build, String branch) throws IllegalArgumentException {
        if (mainRelease < 0 || subRelease < 0 || patchLevel < 0 || build < 0) {
            throw new IllegalArgumentException(String.format("Illegal version %d.%d.%d_%d", mainRelease, subRelease, patchLevel, build));
        }
        this.mainRelease = mainRelease;
        this.subRelease = subRelease;
        this.patchLevel = patchLevel;
        this.build = build;
        this.branch = branch;
    }

    public byte getMainRelease() {
        return this.mainRelease;
    }

    public byte getSubRelease() {
        return this.subRelease;
    }

    public byte getPatchLevel() {
        return this.patchLevel;
    }

    public int getBuild() {
        return this.build;
    }

    public String getBranch() {
        return this.branch;
    }

    public boolean isNewer(Version other) {
        return this.toLong() > other.toLong();
    }

    public boolean isOlder(Version other) {
        return this.toLong() < other.toLong();
    }

    public boolean isEqualOlder(Version other) {
        return this.toLong() <= other.toLong();
    }

    public boolean isEqual(Version other) {
        return this.toLong() == other.toLong();
    }

    public boolean isEqualOrNewer(Version other) {
        return this.toLong() >= other.toLong();
    }

    public String getVersionString() {
        return String.format("%d.%d.%d%s", this.mainRelease, this.subRelease, this.patchLevel, this.getBranchString());
    }

    private String getBranchString() {
        return this.branch != null ? String.format("-%s", this.branch) : "";
    }

    public long toLong() {
        return (long)this.mainRelease << 48 | (long)this.subRelease << 40 | (long)this.patchLevel << 32 | (long)this.build;
    }

    public byte toByte() {
        return (byte)((this.mainRelease & 3) << 6 | (this.subRelease & 3) << 4 | this.patchLevel & 0xF);
    }

    public String toString() {
        return this.getVersionString();
    }

    @Override
    public int compareTo(Version other) {
        if (other.mainRelease < this.mainRelease) {
            return -1;
        }
        if (other.mainRelease > this.mainRelease) {
            return 1;
        }
        if (other.subRelease < this.subRelease) {
            return -1;
        }
        if (other.subRelease > this.subRelease) {
            return 1;
        }
        if (other.patchLevel < this.patchLevel) {
            return -1;
        }
        if (other.patchLevel > this.patchLevel) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        Version that = (Version)other;
        return this.isEqual(that);
    }
}

