/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit;

import at.mrdevelopment.toolkit.ConversionUtils;
import at.mrdevelopment.toolkit.datetime.ReadableTimeFormatter;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public class SystemInfo {
    static ESLLogger logger = ESLLogger.getLogger(SystemInfo.class);

    public static void main(String[] args) throws Exception {
        for (Map.Entry<String, Object> entry : new SystemInfo().asMap().entrySet()) {
            System.out.println(String.format("%s=%s", entry.getKey(), entry.getValue()));
        }
    }

    public String getJavaRuntimeName() {
        return System.getProperty("java.runtime.name");
    }

    public String getJavaVmName() {
        return System.getProperty("java.vm.name");
    }

    public String getJavaRuntimeVersion() {
        return System.getProperty("java.runtime.version");
    }

    public String getJavaHome() {
        return System.getProperty("java.home");
    }

    public String getClasspath() {
        return System.getProperty("java.class.path");
    }

    public String getCwd() {
        return new File(".").getAbsolutePath();
    }

    public String getOsArch() {
        String osArch = System.getProperty("os.arch");
        return osArch != null ? osArch.toUpperCase() : null;
    }

    public String getOsName() {
        return System.getProperty("os.name");
    }

    public String getOsVersion() {
        return System.getProperty("os.version");
    }

    public String getMaxMemory() {
        return ConversionUtils.toMegaByte(Runtime.getRuntime().maxMemory());
    }

    public String getFreeMemory() {
        return ConversionUtils.toMegaByte(Runtime.getRuntime().freeMemory());
    }

    public String getTotalMemory() {
        return ConversionUtils.toMegaByte(Runtime.getRuntime().totalMemory());
    }

    public String getUsedMemory() {
        MemoryMXBean bean = ManagementFactory.getMemoryMXBean();
        return ConversionUtils.toMegaByte(bean.getHeapMemoryUsage().getUsed() + bean.getNonHeapMemoryUsage().getUsed());
    }

    public String getUptime() {
        return ReadableTimeFormatter.printElapsedTime(ManagementFactory.getRuntimeMXBean().getUptime());
    }

    public int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public int getActiveThreads() {
        return Thread.activeCount();
    }

    public boolean isPreferIPv4Stack() {
        return Boolean.valueOf(System.getProperty("java.net.preferIPv4Stack"));
    }

    public void log() {
        for (Map.Entry<String, Object> entry : this.asMap().entrySet()) {
            logger.info(String.format("%s=%s", entry.getKey(), entry.getValue()));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.asMap().entrySet()) {
            builder.append(String.format("%s=%s\n", entry.getKey(), entry.getValue()));
        }
        return builder.toString();
    }

    public SortedMap<String, Object> asMap() {
        try {
            TreeMap<String, Object> systemInfo = new TreeMap<String, Object>();
            for (Method method : SystemInfo.class.getMethods()) {
                if (method.getName().equals("getClass") || !method.getName().startsWith("get") && !method.getName().startsWith("is") || method.getParameterTypes().length != 0) continue;
                String key = StringUtils.capitalize((String)StringUtils.removeStart((String)StringUtils.removeStart((String)method.getName(), (String)"is"), (String)"get"));
                Object value = method.invoke((Object)this, new Object[0]);
                systemInfo.put(key, value);
            }
            return systemInfo;
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    public String getDefaultEncoding() {
        return Charset.defaultCharset().toString();
    }
}

