/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit;

import at.mrdevelopment.toolkit.RequiredVersion;
import at.mrdevelopment.toolkit.Version;
import org.junit.Assert;
import org.junit.Test;

public class RequiredVersionTest {
    @Test
    public void requiresEqualVersion() {
        RequiredVersion requiredVersion = RequiredVersion.fromString("=0.7.4");
        Assert.assertTrue((boolean)requiredVersion.match(Version.fromString("0.7.4-imagotag")));
        Assert.assertTrue((boolean)requiredVersion.match(Version.fromString("0.7.4")));
        Assert.assertFalse((boolean)requiredVersion.match(Version.fromString("0.7.3")));
        Assert.assertFalse((boolean)requiredVersion.match(Version.fromString("0.7.5")));
    }

    @Test
    public void requiresGreaterVersion() {
        RequiredVersion requiredVersion = RequiredVersion.fromString(">0.7.4");
        Assert.assertFalse((boolean)requiredVersion.match(Version.fromString("0.7.4-imagotag")));
        Assert.assertFalse((boolean)requiredVersion.match(Version.fromString("0.7.4")));
        Assert.assertFalse((boolean)requiredVersion.match(Version.fromString("0.7.3")));
        Assert.assertTrue((boolean)requiredVersion.match(Version.fromString("0.7.5")));
    }

    @Test
    public void requiresGreaterEqualVersion() {
        RequiredVersion requiredVersion = RequiredVersion.fromString(">=0.7.4");
        Assert.assertTrue((boolean)requiredVersion.match(Version.fromString("0.7.4-imagotag")));
        Assert.assertTrue((boolean)requiredVersion.match(Version.fromString("0.7.4")));
        Assert.assertFalse((boolean)requiredVersion.match(Version.fromString("0.7.3")));
        Assert.assertTrue((boolean)requiredVersion.match(Version.fromString("0.7.5")));
    }

    @Test
    public void requiresLowerVersion() {
        RequiredVersion requiredVersion = RequiredVersion.fromString("<0.7.4");
        Assert.assertFalse((boolean)requiredVersion.match(Version.fromString("0.7.4-imagotag")));
        Assert.assertFalse((boolean)requiredVersion.match(Version.fromString("0.7.4")));
        Assert.assertTrue((boolean)requiredVersion.match(Version.fromString("0.7.3")));
        Assert.assertFalse((boolean)requiredVersion.match(Version.fromString("0.7.5")));
    }

    @Test
    public void requiresLowerEqualVersion() {
        RequiredVersion requiredVersion = RequiredVersion.fromString("<=0.7.4");
        Assert.assertTrue((boolean)requiredVersion.match(Version.fromString("0.7.4-imagotag")));
        Assert.assertTrue((boolean)requiredVersion.match(Version.fromString("0.7.4")));
        Assert.assertTrue((boolean)requiredVersion.match(Version.fromString("0.7.3")));
        Assert.assertFalse((boolean)requiredVersion.match(Version.fromString("0.7.5")));
    }

    @Test
    public void requiresNotEqualVersion() {
        RequiredVersion requiredVersion = RequiredVersion.fromString("!=0.7.4");
        Assert.assertFalse((boolean)requiredVersion.match(Version.fromString("0.7.4-imagotag")));
        Assert.assertFalse((boolean)requiredVersion.match(Version.fromString("0.7.4")));
        Assert.assertTrue((boolean)requiredVersion.match(Version.fromString("0.7.3")));
        Assert.assertTrue((boolean)requiredVersion.match(Version.fromString("0.7.5")));
    }
}

