/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit;

import at.mrdevelopment.toolkit.RangeIterator;
import at.mrdevelopment.toolkit.Sequence;
import java.util.Iterator;

public class Range<T extends Comparable<T>>
implements Iterable<T> {
    private T from;
    private T to;

    public static <T extends Comparable<T>> Range<T> single(T element) {
        return new Range<T>(element, element);
    }

    public Range(T from, T to) {
        this.from = from;
        this.to = to;
    }

    public boolean contains(T value) {
        return this.from.compareTo(value) <= 0 && this.to.compareTo(value) >= 0;
    }

    public T getFrom() {
        return this.from;
    }

    public T getTo() {
        return this.to;
    }

    public int getCount() {
        Iterator<T> iterator = this.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public boolean isSingleElement() {
        return this.from.compareTo(this.to) == 0;
    }

    public String getRangeString() {
        return this.from.equals(this.to) ? this.from.toString() : String.format("%s to %s", this.from.toString(), this.to.toString());
    }

    public String toString() {
        return String.format("(%s..%s)", this.from.toString(), this.to.toString());
    }

    @Override
    public Iterator<T> iterator() {
        try {
            String className = this.from.getClass().getName() + "Sequence";
            Class<?> sequenceClass = Class.forName(className);
            Sequence sequence = (Sequence)sequenceClass.getDeclaredConstructor(this.from.getClass()).newInstance(this.from);
            return new RangeIterator<T>(sequence, this.to);
        }
        catch (Exception exc) {
            throw new RuntimeException("No sequence found for type " + this.from.getClass());
        }
    }
}

