/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit;

import java.io.File;
import java.io.IOException;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class NetworkUtils {
    public static Collection<String> listInterfaceNames(boolean ignoreLoopbackInterfaces) throws IOException {
        ArrayList<String> interfaceNames = new ArrayList<String>();
        if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            Pattern pattern = Pattern.compile("^ *(.*):");
            List lines = FileUtils.readLines((File)new File("/proc/net/dev"));
            for (String line : lines) {
                String name;
                Matcher match = pattern.matcher(line);
                if (!match.find() || (name = match.group(1)).equals("lo") && ignoreLoopbackInterfaces || name.startsWith("can") || name.startsWith("usb")) continue;
                interfaceNames.add(match.group(1));
            }
        } else {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (networkInterface.isLoopback() && ignoreLoopbackInterfaces) continue;
                interfaceNames.add(networkInterface.getName());
            }
        }
        return interfaceNames;
    }
}

