/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit;

import at.mrdevelopment.toolkit.CidrNetworkAddress;
import at.mrdevelopment.toolkit.NetworkAddress;
import at.mrdevelopment.toolkit.SingleNetworkAddress;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class NetworkAddressUtils {
    public static InetAddress networkPrefixToSubnetMask(int networkPrefixLength) throws UnknownHostException {
        long subnetMaskBits = 0xFFFFFFFFL << 32 - networkPrefixLength & 0xFFFFFFFFL;
        byte[] subnetMaskBytes = new byte[]{(byte)((subnetMaskBits & 0xFF000000L) >> 24), (byte)((subnetMaskBits & 0xFF0000L) >> 16), (byte)((subnetMaskBits & 0xFF00L) >> 8), (byte)((subnetMaskBits & 0xFFL) >> 0)};
        return Inet4Address.getByAddress(subnetMaskBytes);
    }

    public static InetAddress calculateBroadcastAddress(Inet4Address ipAddress, int networkPrefixLength) throws UnknownHostException {
        long invertedSubnetMaskBits = 0xFFFFFFFFL >> networkPrefixLength;
        byte[] addressBytes = ipAddress.getAddress();
        byte[] broadcastBytes = new byte[]{(byte)((long)addressBytes[0] | (invertedSubnetMaskBits & 0xFF000000L) >> 24), (byte)((long)addressBytes[1] | (invertedSubnetMaskBits & 0xFF0000L) >> 16), (byte)((long)addressBytes[2] | (invertedSubnetMaskBits & 0xFF00L) >> 8), (byte)((long)addressBytes[3] | (invertedSubnetMaskBits & 0xFFL) >> 0)};
        return Inet4Address.getByAddress(broadcastBytes);
    }

    public static String hardwareAddressToString(byte[] hardwareAddress) {
        if (hardwareAddress == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (int index = 0; index < hardwareAddress.length; ++index) {
            buffer.append(String.format("%02X%s", hardwareAddress[index], index < hardwareAddress.length - 1 ? ":" : ""));
        }
        return buffer.toString();
    }

    public static NetworkAddress parseNetworkAddress(String addressString) {
        if (addressString == null) {
            throw new IllegalArgumentException("Address must not be null");
        }
        return addressString.contains("/") ? new CidrNetworkAddress(addressString) : new SingleNetworkAddress(addressString);
    }

    public static Collection<NetworkAddress> parseNetworkAddresses(String addressesString) {
        if (addressesString == null) {
            throw new IllegalArgumentException("Address must not be null");
        }
        String[] addresses = StringUtils.split((String)addressesString, (String)";");
        ArrayList<NetworkAddress> addressList = new ArrayList<NetworkAddress>();
        for (String address : addresses) {
            NetworkAddress networkAddress = NetworkAddressUtils.parseNetworkAddress(address);
            if (networkAddress == null) continue;
            addressList.add(networkAddress);
        }
        return addressList;
    }

    public static void main(String[] args) {
        String a1 = "10.18.0.0/16";
        System.out.println(NetworkAddressUtils.parseNetworkAddresses(a1).iterator().next().toString());
    }
}

