/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit;

import java.util.Random;

public class Location {
    private static final Random RANDOM = new Random();
    public static final Location CENTER = new Location(0.0, 0.0);
    private final double distance;
    private final double angle;

    public static Location createRandomLocation(double maxX, double maxY) {
        return Location.createFromCartesian(RANDOM.nextDouble() * maxX, RANDOM.nextDouble() * maxY);
    }

    public static Location createFromCartesian(double x, double y) {
        double distance = Math.sqrt(x * x + y * y);
        double angle = Math.atan(y / x);
        return new Location(distance, angle);
    }

    public static Location createFromPolar(double distance, double angle) {
        return new Location(distance, angle);
    }

    private Location(double distance, double angle) {
        this.distance = distance;
        this.angle = angle;
    }

    public double getX() {
        return Math.cos(this.angle) * this.distance;
    }

    public double getY() {
        return Math.sin(this.angle) * this.distance;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getAngle() {
        return this.angle;
    }

    public double distanceTo(Location location) {
        double gamma = Math.abs(this.angle - location.angle);
        return Math.sqrt(Math.pow(this.distance, 2.0) + Math.pow(location.distance, 2.0) - 2.0 * this.distance * location.distance * Math.cos(gamma));
    }

    public String toString() {
        return String.format("(%.2f, %.2f)", this.getX(), this.getY());
    }
}

