/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit;

import at.mrdevelopment.toolkit.HexFileFormat;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class IntelHexFileReader {
    static ESLLogger logger = ESLLogger.getLogger(IntelHexFileReader.class);
    protected static final int BYTES_PER_LINE = 16;
    protected static final int LINE_PREFIX_LENGTH = 9;
    protected static final int CC2510_BYTES_TO_READ = 29696;
    protected static final int CC2510_BYTES_TO_IGNORE = 2064;
    protected static final int CC26XX_BYTES_TO_READ = 118784;
    protected static final int CC26XX_BYTES_TO_IGNORE = 4096;
    protected static final int SILABS_BYTES_TO_READ = 122880;
    protected static final int SILABS_BYTES_TO_IGNORE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(File firmwareFile, HexFileFormat hexFileFormat) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(firmwareFile));
        try {
            String line;
            byte[] data = new byte[hexFileFormat.getBytesToRead()];
            for (int lineIndex = 0; lineIndex < hexFileFormat.getBytesToIgnore() / hexFileFormat.getBytesPerLine(); ++lineIndex) {
                reader.readLine();
            }
            int absoluteNumBytes = 0;
            int bytesLeft = hexFileFormat.getBytesToRead();
            int byteNumber = 0;
            StringBuilder debugString = new StringBuilder();
            while (bytesLeft > 0 && (line = reader.readLine()) != null) {
                int bytesInLine = Integer.parseInt(line.substring(1, 3), 16);
                int rectypOffset = hexFileFormat.getLinePrefixLength() - 2;
                String rectypEncoded = "0x" + line.charAt(rectypOffset) + line.charAt(rectypOffset + 1);
                if (Integer.decode(rectypEncoded).byteValue() != 0) continue;
                for (int index = 0; index < bytesInLine; ++index) {
                    int dataOffset = index * 2 + hexFileFormat.getLinePrefixLength();
                    String encoded = "0x" + line.charAt(dataOffset) + line.charAt(dataOffset + 1);
                    data[absoluteNumBytes + index] = Integer.decode(encoded).byteValue();
                    if (!logger.isDebugEnabled()) continue;
                    if (byteNumber % 16 == 0) {
                        logger.debug(debugString.toString());
                        debugString = new StringBuilder();
                    }
                    debugString.append("" + line.charAt(dataOffset) + line.charAt(dataOffset + 1));
                    ++byteNumber;
                }
                absoluteNumBytes += bytesInLine;
                bytesLeft -= bytesInLine;
            }
            byte[] byArray = data;
            return byArray;
        }
        finally {
            reader.close();
        }
    }
}

