/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit;

import at.mrdevelopment.toolkit.HexFileFormat;
import at.mrdevelopment.toolkit.IntelHexFileReader;
import java.io.File;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;

public class FirmwareImage {
    private final byte[] data;

    public static FirmwareImage decode(String encodedData) {
        return new FirmwareImage(new Base64().decode(encodedData));
    }

    public static FirmwareImage load(File firmwareFile, HexFileFormat hexFileFormat) throws IOException {
        return new FirmwareImage(IntelHexFileReader.read(firmwareFile, hexFileFormat));
    }

    private FirmwareImage(byte[] data) {
        this.data = data;
    }

    public byte getByte(int index) {
        return this.data[index];
    }

    public byte[] getBytes() {
        return this.data;
    }

    public String getEncodedData() {
        return new Base64().encodeToString(this.data);
    }

    public int getSize() {
        return this.data.length;
    }
}

