/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit;

public enum CompareOperator {
    EQUAL("="),
    LOWER_THAN("<"),
    LOWER_EQUAL("<="),
    GREATER_THAN(">"),
    GREATER_EQUAL(">="),
    NOT_EQUAL("!=");

    String operator;

    private CompareOperator(String operator) {
        this.operator = operator;
    }

    public String getOperator() {
        return this.operator;
    }

    public <T> boolean compare(Comparable<T> operand1, T operand2) {
        int compareResult = operand1.compareTo(operand2);
        if (this == EQUAL) {
            return compareResult == 0;
        }
        if (this == LOWER_THAN) {
            return compareResult > 0;
        }
        if (this == LOWER_EQUAL) {
            return compareResult >= 0;
        }
        if (this == GREATER_THAN) {
            return compareResult < 0;
        }
        if (this == GREATER_EQUAL) {
            return compareResult <= 0;
        }
        if (this == NOT_EQUAL) {
            return compareResult != 0;
        }
        throw new AssertionError();
    }

    public String toString() {
        return this.operator;
    }

    public static CompareOperator fromString(String operator) {
        if (operator != null) {
            for (CompareOperator compareOperator : CompareOperator.values()) {
                if (!operator.equals(compareOperator.getOperator())) continue;
                return compareOperator;
            }
        }
        return null;
    }
}

