/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit;

import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class ClassLoaderBuilder {
    static ESLLogger logger = ESLLogger.getLogger(ClassLoaderBuilder.class);
    private final List<File> classpath = new ArrayList<File>();

    public ClassLoaderBuilder addDirectory(File directory) {
        if (!directory.isDirectory()) {
            return this;
        }
        if (!directory.exists()) {
            return this;
        }
        this.classpath.add(directory);
        return this;
    }

    public List<File> getJarsInDirectory(File directory) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (directory.isDirectory() && directory.exists()) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                if (!FilenameUtils.isExtension((String)file.getPath(), (String)"jar")) continue;
                fileList.add(file);
            }
        }
        return fileList;
    }

    public ClassLoaderBuilder addToClassPath(List<File> files) {
        this.classpath.addAll(files);
        return this;
    }

    public ClassLoader getClassLoader() {
        try {
            URL[] jars = new URL[this.classpath.size()];
            for (int index = 0; index < this.classpath.size(); ++index) {
                jars[index] = this.classpath.get(index).toURI().toURL();
                logger.info("Adding %s to classpath", jars[index]);
            }
            return new URLClassLoader(jars, Thread.currentThread().getContextClassLoader());
        }
        catch (MalformedURLException exc) {
            throw new RuntimeException(exc);
        }
    }
}

