/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit;

import at.mrdevelopment.toolkit.NetworkAddress;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.util.SubnetUtils;

public class CidrNetworkAddress
implements NetworkAddress {
    private final SubnetUtils subnet;

    public CidrNetworkAddress(String address) {
        this.subnet = this.parseAddress(address);
        this.subnet.setInclusiveHostCount(true);
    }

    private SubnetUtils parseAddress(String address) {
        if (address == null) {
            throw new IllegalArgumentException(String.format("Invalid address %s", address));
        }
        String[] split = StringUtils.split((String)address, (String)"/");
        if (split.length != 2) {
            throw new IllegalArgumentException(String.format("Invalid address %s", address));
        }
        if (StringUtils.split((String)split[1], (String)".").length == 4) {
            return new SubnetUtils(split[0], split[1]);
        }
        return new SubnetUtils(address);
    }

    @Override
    public boolean isValid(String address) {
        return this.subnet.getInfo().isInRange(address);
    }

    public String toString() {
        return this.subnet.getInfo().getCidrSignature();
    }
}

