/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit;

import at.mrdevelopment.toolkit.checksum.CRC16;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;

public class AuxPageData {
    private final byte revision;
    private final byte[] data;

    public AuxPageData(byte revision, byte[] data) {
        this.revision = revision;
        this.data = data;
    }

    public byte getRevision() {
        return this.revision;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getBytes() {
        byte[] combinedData = new byte[this.data.length + 1];
        System.arraycopy(this.data, 0, combinedData, 1, this.data.length);
        combinedData[0] = this.revision;
        return combinedData;
    }

    public String getEncodedData() {
        return new Base64().encodeToString(this.getBytes());
    }

    public int getSize() {
        return this.data.length + 1;
    }

    public byte[] prepareData() {
        byte[] dataArray = this.getBytes();
        int paddingSize = 0;
        int necessaryLength = dataArray.length + 2;
        paddingSize = necessaryLength < 32 ? 32 - necessaryLength : necessaryLength % 32;
        byte[] result = new byte[necessaryLength + paddingSize];
        Arrays.fill(result, (byte)-1);
        System.arraycopy(dataArray, 0, result, 0, dataArray.length);
        CRC16 crc16 = new CRC16();
        for (int index = 0; index < result.length - 2; ++index) {
            crc16.calc(result[index]);
        }
        int checksum = crc16.getChecksum();
        result[result.length - 2] = (byte)((checksum & 0xFF00) >> 8);
        result[result.length - 1] = (byte)(checksum & 0xFF);
        return result;
    }

    public static AuxPageData decode(String encodedData) {
        byte[] combinedData = new Base64().decode(encodedData);
        if (combinedData == null || combinedData.length < 2) {
            throw new IllegalArgumentException("Invalid aux page data");
        }
        byte[] data = new byte[combinedData.length - 1];
        System.arraycopy(combinedData, 1, data, 0, data.length);
        return new AuxPageData(combinedData[0], data);
    }
}

