/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.toolkit.file;

import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.FileUtils;

public class FileDeleter {
    static ESLLogger logger = ESLLogger.getLogger(FileDeleter.class);

    public static void deleteFile(File file) {
        if (file != null && file.exists() && !file.isDirectory() && !file.delete()) {
            FileDeleter.doDeleteWorkaround(file);
        }
    }

    public static void deleteFiles(Collection<File> files) {
        for (File file : files) {
            FileDeleter.deleteFile(file);
        }
    }

    private static void doDeleteWorkaround(File file) {
        try {
            System.gc();
            Thread.sleep(500L);
            FileUtils.forceDelete((File)file);
        }
        catch (InterruptedException exception) {
            logger.warn("Could not delete file %s", file.getName());
            logger.logExceptionIfDebugEnabled(exception);
        }
        catch (IOException exception) {
            logger.warn("Could not delete file %s", file.getName());
            logger.logExceptionIfDebugEnabled(exception);
        }
    }
}

