/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.toolkit.file;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public abstract class DynamicFileLoader {
    static ESLLogger logger = ESLLogger.getLogger(DynamicFileLoader.class);

    public DynamicFileLoader(Collection<String> extensions, File ... locations) throws InitializationException {
        ArrayList<File> fileList = new ArrayList<File>();
        logger.info("Loading %s files from %d location(s)", Joiner.on((String)", ").join(extensions), locations.length);
        for (File location : locations) {
            fileList.addAll(this.getFiles(extensions, location));
        }
        try {
            this.processFiles(fileList);
        }
        catch (Exception exc) {
            throw new InitializationException(exc);
        }
    }

    protected abstract void processFiles(List<File> var1) throws Exception;

    private Collection<File> getFiles(final Collection<String> extensions, File file) {
        if (file.exists()) {
            Object[] listFiles = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return FilenameUtils.isExtension((String)pathname.getName(), (Collection)extensions);
                }
            });
            return Lists.newArrayList((Object[])listFiles);
        }
        return Collections.emptyList();
    }
}

