/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.usb;

import at.mrdevelopment.esl.admin.platform.AccessPointSystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.DeviceMode;
import at.mrdevelopment.esl.core.accesspoint.AccessPointModel;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.core.accesspoint.AccessPointTypeMapping;
import at.mrdevelopment.esl.provisioning.ClaimId;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.security.Password;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;

public class USBAccessPointSystemAttributes
implements AccessPointSystemAttributes {
    private final int accessPointId;
    private final Password defaultPassword;
    private final Password password;
    private final int revision = 0;
    private final String serial;

    public USBAccessPointSystemAttributes(int accessPointId) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        this.accessPointId = accessPointId;
        this.password = Password.createFromPlainPassword((String)"admin");
        this.defaultPassword = Password.createFromPlainPassword((String)"admin");
        this.serial = String.format("01A1A00200%1d-I%09d", 0, accessPointId);
    }

    public synchronized AccessPointType getDeviceType() {
        return AccessPointTypeMapping.getType((int)this.accessPointId);
    }

    public int getId() {
        return this.accessPointId;
    }

    public int getRevision() {
        return 0;
    }

    public String getSerial() {
        return this.serial;
    }

    public Password getDefaultPassword() {
        return this.defaultPassword;
    }

    public Password getPassword() {
        return this.password;
    }

    public void setPassword(Password password) throws Exception {
        throw new UnsupportedOperationException("Not available on this platform (setPassword)");
    }

    public void loadDefaultPassword() throws SerializeException, InitializationException {
        throw new UnsupportedOperationException("Not available on this platform (loadDefaultPassword)");
    }

    public boolean isForbidJoin() {
        return false;
    }

    public String getDeviceTypeName() {
        return this.getDeviceType().getDeviceName();
    }

    public String getDefaultHostname() {
        return String.format("ap-%d", this.getId());
    }

    public void setId(int id) throws Exception {
        throw new UnsupportedOperationException("Not supported");
    }

    public void setRevision(int revision) throws Exception {
        throw new UnsupportedOperationException("Not supported");
    }

    public DeviceMode getDeviceMode() {
        return DeviceMode.ACCESSPOINT;
    }

    public void setDeviceMode(DeviceMode mode) throws Exception {
        throw new UnsupportedOperationException("Not supported");
    }

    public void setSerial(String serial) throws Exception {
        throw new UnsupportedOperationException("Not supported");
    }

    public void reload() throws SerializeException, InitializationException {
    }

    public void setClaimId(String claimId) throws Exception {
        throw new UnsupportedOperationException("Not supported");
    }

    public AccessPointModel getDeviceModel() {
        throw new UnsupportedOperationException("Not supported");
    }

    public ClaimId getClaimId() {
        throw new UnsupportedOperationException("Not supported");
    }
}

