/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.usb;

import at.mrdevelopment.esl.accesspoint.AccessPoint;
import at.mrdevelopment.esl.accesspoint.AccessPointCommonDataListener;
import at.mrdevelopment.esl.accesspoint.AccessPointDataListener;
import at.mrdevelopment.esl.accesspoint.AccessPointMSPStatusTask;
import at.mrdevelopment.esl.accesspoint.AccessPointModule;
import at.mrdevelopment.esl.accesspoint.AccessPointRuntimeConfiguration;
import at.mrdevelopment.esl.accesspoint.AccessPointWakeupStatisticsListenerIF;
import at.mrdevelopment.esl.accesspoint.RequestQueue;
import at.mrdevelopment.esl.accesspoint.SendBroadcastTask;
import at.mrdevelopment.esl.accesspoint.SlotPipelineProcessing;
import at.mrdevelopment.esl.accesspoint.ThinAccessPointDataListener;
import at.mrdevelopment.esl.accesspoint.TimeoutLabelEvents;
import at.mrdevelopment.esl.accesspoint.TimeoutUpdateTasks;
import at.mrdevelopment.esl.accesspoint.TimeoutWakeupStatisticsListenerTask;
import at.mrdevelopment.esl.accesspoint.UpdateRegisteredLabelDocumentTask;
import at.mrdevelopment.esl.accesspoint.UpdateServiceStatusTask;
import at.mrdevelopment.esl.accesspoint.controller.StandaloneThinAccessPointWebServerConfiguration;
import at.mrdevelopment.esl.accesspoint.controller.ThinAccessPointWebServerConfiguration;
import at.mrdevelopment.esl.accesspoint.http.AccessPointHttpServer;
import at.mrdevelopment.esl.accesspoint.mode.AccessPointMode;
import at.mrdevelopment.esl.accesspoint.mode.AccessPointThinMode;
import at.mrdevelopment.esl.accesspoint.serial.SerialConfigurationManager;
import at.mrdevelopment.esl.accesspoint.taskqueue.SlotPipeline;
import at.mrdevelopment.esl.accesspoint.usb.MemoryBackendControl;
import at.mrdevelopment.esl.accesspoint.usb.USBAccessPointSystemAttributes;
import at.mrdevelopment.esl.admin.platform.AccessPointSystemAttributes;
import at.mrdevelopment.esl.admin.platform.SystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.WirelessConfiguration;
import at.mrdevelopment.esl.admin.platform.config.control.AccessPointBackendControl;
import at.mrdevelopment.esl.admin.platform.config.control.BackendControl;
import at.mrdevelopment.esl.admin.platform.config.manager.AccessPointConfigurationManager;
import at.mrdevelopment.esl.admin.platform.config.storage.ConfigurationStorage;
import at.mrdevelopment.esl.admin.platform.config.storage.DefaultAccessPointConfigurationStorage;
import at.mrdevelopment.esl.admin.platform.config.storage.MemoryPlatformStorage;
import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.esl.core.DefaultPeriodicTasksExecutor;
import at.mrdevelopment.esl.core.ESLProcessingTask;
import at.mrdevelopment.esl.core.PeriodicTasksExecutor;
import at.mrdevelopment.esl.core.UpdateTaskQueueListener;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.ShutdownableShutdownHook;
import at.mrdevelopment.toolkit.http.BasicHttpServer;
import at.mrdevelopment.toolkit.info.Info;
import at.mrdevelopment.toolkit.log.ESLLogger;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import java.net.SocketException;
import java.security.Provider;
import java.security.Security;
import java.util.HashSet;
import java.util.Set;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class USBAccessPoint
implements Shutdownable {
    public static final String APPLICATION_NAME = "SES-imagotag USB Access Point";
    public static final String DEVICE_TYPE = "SES-imagotag USB Access Point";
    private static final int DEFAULT_TCP_LISTEN_PORT = 8080;
    private static final String DEFAULT_SERIAL_PORT = "COM10";
    private static final int DEFAULT_BAUD_RATE = 230400;
    static ESLLogger logger;
    private final int accessPointId;
    private final Set<Shutdownable> shutdownables = new HashSet<Shutdownable>();
    private ThinAccessPointDataListener accessPointDataListener;
    private AccessPoint accessPoint;
    private RequestQueue requestQueue;

    public static void main(String[] args) {
        logger.info("Starting %s", new Object[]{"SES-imagotag USB Access Point"});
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec optionPort = parser.accepts("port").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec optionSerialPort = parser.accepts("serial").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec optionBaudRate = parser.accepts("baud-rate").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec optionAccessPointId = parser.accepts("access-point-id").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec optionChannel = parser.accepts("channel").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec optionWindowSize = parser.accepts("window-size").withRequiredArg().ofType(Integer.class);
        OptionSet options = parser.parse(args);
        if (!options.has((OptionSpec)optionAccessPointId)) {
            System.out.println("No access point ID specified");
            System.exit(1);
        }
        int accessPointId = (Integer)options.valueOf((OptionSpec)optionAccessPointId);
        int port = options.has((OptionSpec)optionPort) ? (Integer)options.valueOf((OptionSpec)optionPort) : 8080;
        String serialPortName = options.has((OptionSpec)optionSerialPort) ? (String)options.valueOf((OptionSpec)optionSerialPort) : DEFAULT_SERIAL_PORT;
        int baudRate = options.has((OptionSpec)optionBaudRate) ? (Integer)options.valueOf((OptionSpec)optionBaudRate) : 230400;
        Integer channelNumber = options.has((OptionSpec)optionChannel) ? (Integer)options.valueOf((OptionSpec)optionChannel) : null;
        int windowSize = options.has((OptionSpec)optionWindowSize) ? (Integer)options.valueOf((OptionSpec)optionWindowSize) : 14;
        try {
            new USBAccessPoint(serialPortName, baudRate, port, accessPointId, channelNumber, windowSize, "firmware.xml", new StandaloneThinAccessPointWebServerConfiguration(port));
        }
        catch (PortInUseException exc) {
            logger.error("Serial port %s already in use", new Object[]{serialPortName});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
            System.exit(1);
        }
        catch (NoSuchPortException exc) {
            logger.error("Unknown serial port %s", new Object[]{serialPortName});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
            System.exit(1);
        }
        catch (SocketException exc) {
            logger.error("Could not create socket: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
            System.exit(1);
        }
        catch (UnsatisfiedLinkError exc) {
            logger.error("Missing native libary: %s", new Object[]{exc.getMessage()});
            logger.error("Add -Djava.library.path=<path to native libs> as Java VM argument");
            System.exit(1);
        }
        catch (InitializationException exc) {
            logger.error("Error during imagotag USB Access Point initialization");
            logger.logException((Throwable)exc);
            System.exit(1);
        }
        catch (Exception exc) {
            logger.error("Unknown error during startup of imagotag USB Access Point. See stack trace for details.");
            logger.logException((Throwable)exc);
            System.exit(1);
        }
    }

    public USBAccessPoint(String serialPortName, int baudRate, int port, int accessPointId, Integer channelNumber, String firmwareFile, ThinAccessPointWebServerConfiguration webServerConfiguration) throws Exception {
        this(serialPortName, baudRate, port, accessPointId, channelNumber, 14, firmwareFile, webServerConfiguration);
    }

    public USBAccessPoint(String serialPortName, int baudRate, int port, int accessPointId, Integer channelNumber, int windowSize, String firmwareFile, ThinAccessPointWebServerConfiguration webServerConfiguration) throws Exception {
        this.accessPointId = accessPointId;
        System.setProperty("serial.receivetimeout", "true");
        MemoryPlatformStorage accessPointStorage = new MemoryPlatformStorage();
        MemoryBackendControl backendControl = new MemoryBackendControl();
        DefaultAccessPointConfigurationStorage configurationStorage = new DefaultAccessPointConfigurationStorage((PlatformStorage)accessPointStorage);
        USBAccessPointSystemAttributes systemAttributes = new USBAccessPointSystemAttributes(accessPointId);
        if (channelNumber != null) {
            accessPointStorage.storeKey("wireless.channel", channelNumber.toString());
            accessPointStorage.storeKey("wireless.windowsize", String.valueOf(windowSize));
            accessPointStorage.storeKey("wireless.max.power", WirelessConfiguration.DEFAULT_FCC_POWER_SETTING.name());
        }
        Info info = Info.load(AccessPoint.class);
        AccessPointConfigurationManager configurationManager = new AccessPointConfigurationManager((BackendControl)backendControl, (ConfigurationStorage)configurationStorage);
        AccessPointRuntimeConfiguration runtimeConfiguration = new AccessPointRuntimeConfiguration(info, port, systemAttributes.getDeviceMode(), false, false);
        this.requestQueue = new RequestQueue();
        SlotPipeline slotPipeline = new SlotPipeline(16);
        this.accessPoint = new AccessPoint(configurationManager, (AccessPointSystemAttributes)systemAttributes, runtimeConfiguration, this.requestQueue, false, firmwareFile, false);
        SlotPipelineProcessing slotPipelineProcessing = new SlotPipelineProcessing(this.accessPoint, slotPipeline);
        slotPipelineProcessing.startProcessingThread();
        SerialConfigurationManager serialConfigurationManager = new SerialConfigurationManager(slotPipeline, slotPipelineProcessing, this.accessPoint, serialPortName, baudRate, false);
        this.accessPointDataListener = ThinAccessPointDataListener.createForUSBAccessPoint(this.accessPoint, configurationManager, systemAttributes, runtimeConfiguration);
        this.requestQueue.registerUpdateTaskQueueListener((UpdateTaskQueueListener)this.accessPointDataListener.getServiceStatusListener());
        DefaultPeriodicTasksExecutor taskExecutor = new DefaultPeriodicTasksExecutor(){

            public long getReloadTime() {
                return 10000L;
            }
        };
        taskExecutor.addProcessingTask((ESLProcessingTask)new AccessPointMSPStatusTask((AccessPointCommonDataListener)this.accessPointDataListener, configurationManager));
        taskExecutor.addProcessingTask((ESLProcessingTask)new SendBroadcastTask((AccessPointCommonDataListener)this.accessPointDataListener, configurationManager, (SystemAttributes)systemAttributes, runtimeConfiguration));
        taskExecutor.addProcessingTask((ESLProcessingTask)new TimeoutUpdateTasks((AccessPointDataListener)this.accessPointDataListener, this.requestQueue));
        taskExecutor.addProcessingTask((ESLProcessingTask)new TimeoutLabelEvents((AccessPointDataListener)this.accessPointDataListener));
        taskExecutor.addProcessingTask((ESLProcessingTask)new TimeoutWakeupStatisticsListenerTask((AccessPointWakeupStatisticsListenerIF)this.accessPointDataListener.getWakeupStatisticsListener()));
        taskExecutor.addProcessingTask((ESLProcessingTask)new UpdateServiceStatusTask((AccessPointCommonDataListener)this.accessPointDataListener));
        taskExecutor.addProcessingTask((ESLProcessingTask)new UpdateRegisteredLabelDocumentTask(this.accessPointDataListener.getServiceStatusListener()));
        AccessPointHttpServer httpServer = new AccessPointHttpServer(this.accessPoint, AccessPointMode.createOnServer((boolean)false, (AccessPointThinMode)AccessPointThinMode.TCP), (AccessPointCommonDataListener)this.accessPointDataListener, this.requestQueue, (AccessPointBackendControl)backendControl, configurationManager, (AccessPointSystemAttributes)systemAttributes, runtimeConfiguration, serialConfigurationManager);
        webServerConfiguration.startServer((BasicHttpServer)httpServer);
        taskExecutor.start();
        AccessPointModule accessPointModule = new AccessPointModule(slotPipeline, this.accessPoint, (PeriodicTasksExecutor)taskExecutor, httpServer);
        this.shutdownables.add((Shutdownable)accessPointModule);
        this.shutdownables.add((Shutdownable)slotPipelineProcessing);
        this.shutdownables.add((Shutdownable)serialConfigurationManager);
        Runtime.getRuntime().addShutdownHook((Thread)new ShutdownableShutdownHook(new Shutdownable[]{accessPointModule, slotPipelineProcessing, serialConfigurationManager}));
    }

    public void shutdown() {
        for (Shutdownable shutdownable : this.shutdownables) {
            shutdownable.shutdown();
        }
    }

    public int getAccessPointId() {
        return this.accessPointId;
    }

    public ThinAccessPointDataListener getAccessPointDataListener() {
        return this.accessPointDataListener;
    }

    public AccessPoint getAccessPoint() {
        return this.accessPoint;
    }

    public RequestQueue getRequestQueue() {
        return this.requestQueue;
    }

    static {
        ESLLogger.initLogger((boolean)true);
        Security.addProvider((Provider)new BouncyCastleProvider());
        logger = ESLLogger.getLogger(USBAccessPoint.class);
    }
}

