/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.controller.xml;

import at.mrdevelopment.esl.accesspoint.controller.AccessPointControllerConfiguration;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AccessPointControllerConfigurationXMLSerializer
implements XMLSerializer<AccessPointControllerConfiguration> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document toXML(Collection<AccessPointControllerConfiguration> configurations) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("AccessPointControllerConfigurations");
        for (AccessPointControllerConfiguration configuration : configurations) {
            root.appendChild(this.toXML(configuration, document));
        }
        document.appendChild(root);
        return document;
    }

    private Element toXML(AccessPointControllerConfiguration configuration, Document document) {
        Element configurationElement = document.createElement("AccessPointControllerConfiguration");
        configurationElement.setAttribute("id", String.valueOf(configuration.getAccessPointId()));
        configurationElement.setAttribute("address", configuration.getAddress());
        if (configuration.getPort() != null) {
            configurationElement.setAttribute("port", String.valueOf(configuration.getPort()));
        }
        return configurationElement;
    }

    public Collection<AccessPointControllerConfiguration> parseConfigurations(InputStream inputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(inputStream);
        return this.parseConfigurations(root);
    }

    public Collection<AccessPointControllerConfiguration> parseConfigurations(Element root) throws SerializeException {
        ArrayList<AccessPointControllerConfiguration> configurations = new ArrayList<AccessPointControllerConfiguration>();
        NodeList nodeList = root.getElementsByTagName("AccessPointControllerConfiguration");
        if (nodeList.getLength() > 0) {
            for (int index = 0; index < nodeList.getLength(); ++index) {
                Element configurationElement = (Element)nodeList.item(index);
                configurations.add(this.parseConfiguration(configurationElement));
            }
        }
        return configurations;
    }

    private AccessPointControllerConfiguration parseConfiguration(Element configurationElement) throws SerializeException {
        Integer accessPointId;
        String address = configurationElement.getAttribute("address");
        Integer port = configurationElement.hasAttribute("port") ? Integer.valueOf(configurationElement.getAttribute("port")) : null;
        Integer n = accessPointId = configurationElement.hasAttribute("id") ? Integer.valueOf(configurationElement.getAttribute("id")) : null;
        if (accessPointId == null || port == null || address == null) {
            throw new SerializeException("Invalid configuration (missing port/address/id)", new Object[0]);
        }
        return new AccessPointControllerConfiguration(accessPointId, address, port);
    }
}

